/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.util.List;
import org.apache.lucene.index.CodecReader;
import org.apache.lucene.index.MergeState;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.OrdinalMap;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.Sorter;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.LongValues;
import org.apache.lucene.util.PriorityQueue;
import org.apache.lucene.util.packed.PackedLongValues;

final class MultiSorter {
    MultiSorter() {
    }

    static MergeState.DocMap[] sort(Sort sort, List<CodecReader> readers) throws IOException {
        SortField[] fields = sort.getSort();
        final ComparableProvider[][] comparables = new ComparableProvider[fields.length][];
        for (int i2 = 0; i2 < fields.length; ++i2) {
            comparables[i2] = MultiSorter.getComparableProviders(readers, fields[i2]);
        }
        int leafCount = readers.size();
        PriorityQueue<LeafAndDocID> queue = new PriorityQueue<LeafAndDocID>(leafCount){

            @Override
            public boolean lessThan(LeafAndDocID a2, LeafAndDocID b2) {
                for (int i2 = 0; i2 < comparables.length; ++i2) {
                    int cmp = a2.values[i2].compareTo(b2.values[i2]);
                    if (cmp == 0) continue;
                    return cmp < 0;
                }
                if (a2.readerIndex != b2.readerIndex) {
                    return a2.readerIndex < b2.readerIndex;
                }
                return a2.docID < b2.docID;
            }
        };
        PackedLongValues.Builder[] builders = new PackedLongValues.Builder[leafCount];
        for (int i3 = 0; i3 < leafCount; ++i3) {
            CodecReader reader = readers.get(i3);
            LeafAndDocID leaf = new LeafAndDocID(i3, reader.getLiveDocs(), reader.maxDoc(), comparables.length);
            for (int j2 = 0; j2 < comparables.length; ++j2) {
                leaf.values[j2] = comparables[j2][i3].getComparable(leaf.docID);
                assert (leaf.values[j2] != null);
            }
            queue.add(leaf);
            builders[i3] = PackedLongValues.monotonicBuilder(0.0f);
        }
        int mappedDocID = 0;
        int lastReaderIndex = 0;
        boolean isSorted = true;
        while (queue.size() != 0) {
            LeafAndDocID top = (LeafAndDocID)queue.top();
            if (lastReaderIndex > top.readerIndex) {
                isSorted = false;
            }
            lastReaderIndex = top.readerIndex;
            builders[top.readerIndex].add(mappedDocID);
            if (top.liveDocs == null || top.liveDocs.get(top.docID)) {
                ++mappedDocID;
            }
            ++top.docID;
            if (top.docID < top.maxDoc) {
                for (int j3 = 0; j3 < comparables.length; ++j3) {
                    top.values[j3] = comparables[j3][top.readerIndex].getComparable(top.docID);
                    assert (top.values[j3] != null);
                }
                queue.updateTop();
                continue;
            }
            queue.pop();
        }
        if (isSorted) {
            return null;
        }
        MergeState.DocMap[] docMaps = new MergeState.DocMap[leafCount];
        for (int i4 = 0; i4 < leafCount; ++i4) {
            final PackedLongValues remapped = builders[i4].build();
            final Bits liveDocs = readers.get(i4).getLiveDocs();
            docMaps[i4] = new MergeState.DocMap(){

                @Override
                public int get(int docID) {
                    if (liveDocs == null || liveDocs.get(docID)) {
                        return (int)remapped.get(docID);
                    }
                    return -1;
                }
            };
        }
        return docMaps;
    }

    private static ComparableProvider[] getComparableProviders(List<CodecReader> readers, SortField sortField) throws IOException {
        ComparableProvider[] providers = new ComparableProvider[readers.size()];
        final int reverseMul = sortField.getReverse() ? -1 : 1;
        SortField.Type sortType = Sorter.getSortFieldType(sortField);
        switch (sortType) {
            case STRING: {
                SortedDocValues[] values = new SortedDocValues[readers.size()];
                for (int i2 = 0; i2 < readers.size(); ++i2) {
                    SortedDocValues sorted;
                    values[i2] = sorted = Sorter.getOrWrapSorted(readers.get(i2), sortField);
                }
                OrdinalMap ordinalMap = OrdinalMap.build(null, values, 0.25f);
                final int missingOrd = sortField.getMissingValue() == SortField.STRING_LAST ? (sortField.getReverse() ? Integer.MIN_VALUE : Integer.MAX_VALUE) : (sortField.getReverse() ? Integer.MAX_VALUE : Integer.MIN_VALUE);
                for (int readerIndex = 0; readerIndex < readers.size(); ++readerIndex) {
                    final SortedDocValues readerValues = values[readerIndex];
                    final LongValues globalOrds = ordinalMap.getGlobalOrds(readerIndex);
                    providers[readerIndex] = new ComparableProvider(){
                        int lastDocID = -1;

                        private boolean docsInOrder(int docID) {
                            if (docID < this.lastDocID) {
                                throw new AssertionError((Object)("docs must be sent in order, but lastDocID=" + this.lastDocID + " vs docID=" + docID));
                            }
                            this.lastDocID = docID;
                            return true;
                        }

                        @Override
                        public Comparable getComparable(int docID) throws IOException {
                            assert (this.docsInOrder(docID));
                            int readerDocID = readerValues.docID();
                            if (readerDocID < docID) {
                                readerDocID = readerValues.advance(docID);
                            }
                            if (readerDocID == docID) {
                                return Integer.valueOf(reverseMul * (int)globalOrds.get(readerValues.ordValue()));
                            }
                            return Integer.valueOf(missingOrd);
                        }
                    };
                }
                break;
            }
            case LONG: {
                final Long missingValue = sortField.getMissingValue() != null ? (Long)sortField.getMissingValue() : Long.valueOf(0L);
                for (int readerIndex = 0; readerIndex < readers.size(); ++readerIndex) {
                    final NumericDocValues values = Sorter.getOrWrapNumeric(readers.get(readerIndex), sortField);
                    providers[readerIndex] = new ComparableProvider(){
                        int lastDocID = -1;

                        private boolean docsInOrder(int docID) {
                            if (docID < this.lastDocID) {
                                throw new AssertionError((Object)("docs must be sent in order, but lastDocID=" + this.lastDocID + " vs docID=" + docID));
                            }
                            this.lastDocID = docID;
                            return true;
                        }

                        @Override
                        public Comparable getComparable(int docID) throws IOException {
                            assert (this.docsInOrder(docID));
                            int readerDocID = values.docID();
                            if (readerDocID < docID) {
                                readerDocID = values.advance(docID);
                            }
                            if (readerDocID == docID) {
                                return Long.valueOf((long)reverseMul * values.longValue());
                            }
                            return Long.valueOf((long)reverseMul * missingValue);
                        }
                    };
                }
                break;
            }
            case INT: {
                final Integer missingValue = sortField.getMissingValue() != null ? (Integer)sortField.getMissingValue() : Integer.valueOf(0);
                for (int readerIndex = 0; readerIndex < readers.size(); ++readerIndex) {
                    final NumericDocValues values = Sorter.getOrWrapNumeric(readers.get(readerIndex), sortField);
                    providers[readerIndex] = new ComparableProvider(){
                        int lastDocID = -1;

                        private boolean docsInOrder(int docID) {
                            if (docID < this.lastDocID) {
                                throw new AssertionError((Object)("docs must be sent in order, but lastDocID=" + this.lastDocID + " vs docID=" + docID));
                            }
                            this.lastDocID = docID;
                            return true;
                        }

                        @Override
                        public Comparable getComparable(int docID) throws IOException {
                            assert (this.docsInOrder(docID));
                            int readerDocID = values.docID();
                            if (readerDocID < docID) {
                                readerDocID = values.advance(docID);
                            }
                            if (readerDocID == docID) {
                                return Integer.valueOf(reverseMul * (int)values.longValue());
                            }
                            return Integer.valueOf(reverseMul * missingValue);
                        }
                    };
                }
                break;
            }
            case DOUBLE: {
                final Double missingValue = sortField.getMissingValue() != null ? (Double)sortField.getMissingValue() : Double.valueOf(0.0);
                for (int readerIndex = 0; readerIndex < readers.size(); ++readerIndex) {
                    final NumericDocValues values = Sorter.getOrWrapNumeric(readers.get(readerIndex), sortField);
                    providers[readerIndex] = new ComparableProvider(){
                        int lastDocID = -1;

                        private boolean docsInOrder(int docID) {
                            if (docID < this.lastDocID) {
                                throw new AssertionError((Object)("docs must be sent in order, but lastDocID=" + this.lastDocID + " vs docID=" + docID));
                            }
                            this.lastDocID = docID;
                            return true;
                        }

                        @Override
                        public Comparable getComparable(int docID) throws IOException {
                            assert (this.docsInOrder(docID));
                            int readerDocID = values.docID();
                            if (readerDocID < docID) {
                                readerDocID = values.advance(docID);
                            }
                            if (readerDocID == docID) {
                                return Double.valueOf((double)reverseMul * Double.longBitsToDouble(values.longValue()));
                            }
                            return Double.valueOf((double)reverseMul * missingValue);
                        }
                    };
                }
                break;
            }
            case FLOAT: {
                final Float missingValue = sortField.getMissingValue() != null ? (Float)sortField.getMissingValue() : Float.valueOf(0.0f);
                for (int readerIndex = 0; readerIndex < readers.size(); ++readerIndex) {
                    final NumericDocValues values = Sorter.getOrWrapNumeric(readers.get(readerIndex), sortField);
                    providers[readerIndex] = new ComparableProvider(){
                        int lastDocID = -1;

                        private boolean docsInOrder(int docID) {
                            if (docID < this.lastDocID) {
                                throw new AssertionError((Object)("docs must be sent in order, but lastDocID=" + this.lastDocID + " vs docID=" + docID));
                            }
                            this.lastDocID = docID;
                            return true;
                        }

                        @Override
                        public Comparable getComparable(int docID) throws IOException {
                            assert (this.docsInOrder(docID));
                            int readerDocID = values.docID();
                            if (readerDocID < docID) {
                                readerDocID = values.advance(docID);
                            }
                            if (readerDocID == docID) {
                                return Float.valueOf((float)reverseMul * Float.intBitsToFloat((int)values.longValue()));
                            }
                            return Float.valueOf((float)reverseMul * missingValue.floatValue());
                        }
                    };
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("unhandled SortField.getType()=" + (Object)((Object)sortField.getType()));
            }
        }
        return providers;
    }

    private static interface ComparableProvider {
        public Comparable getComparable(int var1) throws IOException;
    }

    private static class LeafAndDocID {
        final int readerIndex;
        final Bits liveDocs;
        final int maxDoc;
        final Comparable[] values;
        int docID;

        public LeafAndDocID(int readerIndex, Bits liveDocs, int maxDoc, int numComparables) {
            this.readerIndex = readerIndex;
            this.liveDocs = liveDocs;
            this.maxDoc = maxDoc;
            this.values = new Comparable[numComparables];
        }
    }
}

