/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.Accountables;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.apache.lucene.util.InPlaceMergeSorter;
import org.apache.lucene.util.LongValues;
import org.apache.lucene.util.PriorityQueue;
import org.apache.lucene.util.RamUsageEstimator;
import org.apache.lucene.util.packed.PackedInts;
import org.apache.lucene.util.packed.PackedLongValues;

public class OrdinalMap
implements Accountable {
    private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(OrdinalMap.class);
    public final IndexReader.CacheKey owner;
    final PackedLongValues globalOrdDeltas;
    final PackedLongValues firstSegments;
    final LongValues[] segmentToGlobalOrds;
    final SegmentMap segmentMap;
    final long ramBytesUsed;

    public static OrdinalMap build(IndexReader.CacheKey owner, SortedDocValues[] values, float acceptableOverheadRatio) throws IOException {
        TermsEnum[] subs = new TermsEnum[values.length];
        long[] weights = new long[values.length];
        for (int i2 = 0; i2 < values.length; ++i2) {
            subs[i2] = values[i2].termsEnum();
            weights[i2] = values[i2].getValueCount();
        }
        return OrdinalMap.build(owner, subs, weights, acceptableOverheadRatio);
    }

    public static OrdinalMap build(IndexReader.CacheKey owner, SortedSetDocValues[] values, float acceptableOverheadRatio) throws IOException {
        TermsEnum[] subs = new TermsEnum[values.length];
        long[] weights = new long[values.length];
        for (int i2 = 0; i2 < values.length; ++i2) {
            subs[i2] = values[i2].termsEnum();
            weights[i2] = values[i2].getValueCount();
        }
        return OrdinalMap.build(owner, subs, weights, acceptableOverheadRatio);
    }

    public static OrdinalMap build(IndexReader.CacheKey owner, TermsEnum[] subs, long[] weights, float acceptableOverheadRatio) throws IOException {
        if (subs.length != weights.length) {
            throw new IllegalArgumentException("subs and weights must have the same length");
        }
        SegmentMap segmentMap = new SegmentMap(weights);
        return new OrdinalMap(owner, subs, segmentMap, acceptableOverheadRatio);
    }

    OrdinalMap(IndexReader.CacheKey owner, TermsEnum[] subs, SegmentMap segmentMap, float acceptableOverheadRatio) throws IOException {
        this.owner = owner;
        this.segmentMap = segmentMap;
        PackedLongValues.Builder globalOrdDeltas = PackedLongValues.monotonicBuilder(0.0f);
        PackedLongValues.Builder firstSegments = PackedLongValues.packedBuilder(0.0f);
        PackedLongValues.Builder[] ordDeltas = new PackedLongValues.Builder[subs.length];
        for (int i2 = 0; i2 < ordDeltas.length; ++i2) {
            ordDeltas[i2] = PackedLongValues.monotonicBuilder(acceptableOverheadRatio);
        }
        long[] ordDeltaBits = new long[subs.length];
        long[] segmentOrds = new long[subs.length];
        PriorityQueue<TermsEnumIndex> queue = new PriorityQueue<TermsEnumIndex>(subs.length){

            @Override
            protected boolean lessThan(TermsEnumIndex a2, TermsEnumIndex b2) {
                return a2.currentTerm.compareTo(b2.currentTerm) < 0;
            }
        };
        for (int i3 = 0; i3 < subs.length; ++i3) {
            TermsEnumIndex sub = new TermsEnumIndex(subs[segmentMap.newToOld(i3)], i3);
            if (sub.next() == null) continue;
            queue.add(sub);
        }
        BytesRefBuilder scratch = new BytesRefBuilder();
        long globalOrd = 0L;
        while (queue.size() != 0) {
            TermsEnumIndex top = (TermsEnumIndex)queue.top();
            scratch.copyBytes(top.currentTerm);
            int firstSegmentIndex = Integer.MAX_VALUE;
            long globalOrdDelta = Long.MAX_VALUE;
            do {
                top = (TermsEnumIndex)queue.top();
                long segmentOrd = top.termsEnum.ord();
                long delta = globalOrd - segmentOrd;
                int segmentIndex = top.subIndex;
                if (segmentIndex < firstSegmentIndex) {
                    firstSegmentIndex = segmentIndex;
                    globalOrdDelta = delta;
                }
                int n2 = segmentIndex;
                ordDeltaBits[n2] = ordDeltaBits[n2] | delta;
                assert (segmentOrds[segmentIndex] <= segmentOrd);
                do {
                    ordDeltas[segmentIndex].add(delta);
                    int n3 = segmentIndex;
                    segmentOrds[n3] = segmentOrds[n3] + 1L;
                } while (segmentOrds[segmentIndex] <= segmentOrd);
                if (top.next() == null) {
                    queue.pop();
                    if (queue.size() != 0) continue;
                    break;
                }
                queue.updateTop();
            } while (((TermsEnumIndex)queue.top()).currentTerm.equals(scratch.get()));
            firstSegments.add(firstSegmentIndex);
            globalOrdDeltas.add(globalOrdDelta);
            ++globalOrd;
        }
        this.firstSegments = firstSegments.build();
        this.globalOrdDeltas = globalOrdDeltas.build();
        this.segmentToGlobalOrds = new LongValues[subs.length];
        long ramBytesUsed = BASE_RAM_BYTES_USED + this.globalOrdDeltas.ramBytesUsed() + this.firstSegments.ramBytesUsed() + RamUsageEstimator.shallowSizeOf(this.segmentToGlobalOrds) + segmentMap.ramBytesUsed();
        for (int i4 = 0; i4 < ordDeltas.length; ++i4) {
            final PackedLongValues deltas = ordDeltas[i4].build();
            if (ordDeltaBits[i4] == 0L) {
                this.segmentToGlobalOrds[i4] = LongValues.IDENTITY;
                continue;
            }
            int bitsRequired = ordDeltaBits[i4] < 0L ? 64 : PackedInts.bitsRequired(ordDeltaBits[i4]);
            long monotonicBits = deltas.ramBytesUsed() * 8L;
            long packedBits = (long)bitsRequired * deltas.size();
            if (deltas.size() <= Integer.MAX_VALUE && (float)packedBits <= (float)monotonicBits * (1.0f + acceptableOverheadRatio)) {
                int size = (int)deltas.size();
                final PackedInts.Mutable newDeltas = PackedInts.getMutable(size, bitsRequired, acceptableOverheadRatio);
                PackedLongValues.Iterator it = deltas.iterator();
                for (int ord = 0; ord < size; ++ord) {
                    newDeltas.set(ord, it.next());
                }
                assert (!it.hasNext());
                this.segmentToGlobalOrds[i4] = new LongValues(){

                    @Override
                    public long get(long ord) {
                        return ord + newDeltas.get((int)ord);
                    }
                };
                ramBytesUsed += newDeltas.ramBytesUsed();
            } else {
                this.segmentToGlobalOrds[i4] = new LongValues(){

                    @Override
                    public long get(long ord) {
                        return ord + deltas.get(ord);
                    }
                };
                ramBytesUsed += deltas.ramBytesUsed();
            }
            ramBytesUsed += RamUsageEstimator.shallowSizeOf(this.segmentToGlobalOrds[i4]);
        }
        this.ramBytesUsed = ramBytesUsed;
    }

    public LongValues getGlobalOrds(int segmentIndex) {
        return this.segmentToGlobalOrds[this.segmentMap.oldToNew(segmentIndex)];
    }

    public long getFirstSegmentOrd(long globalOrd) {
        return globalOrd - this.globalOrdDeltas.get(globalOrd);
    }

    public int getFirstSegmentNumber(long globalOrd) {
        return this.segmentMap.newToOld((int)this.firstSegments.get(globalOrd));
    }

    public long getValueCount() {
        return this.globalOrdDeltas.size();
    }

    @Override
    public long ramBytesUsed() {
        return this.ramBytesUsed;
    }

    @Override
    public Collection<Accountable> getChildResources() {
        ArrayList<Accountable> resources = new ArrayList<Accountable>();
        resources.add(Accountables.namedAccountable("global ord deltas", this.globalOrdDeltas));
        resources.add(Accountables.namedAccountable("first segments", this.firstSegments));
        resources.add(Accountables.namedAccountable("segment map", this.segmentMap));
        return resources;
    }

    private static class SegmentMap
    implements Accountable {
        private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(SegmentMap.class);
        private final int[] newToOld;
        private final int[] oldToNew;

        private static int[] map(final long[] weights) {
            final int[] newToOld = new int[weights.length];
            for (int i2 = 0; i2 < weights.length; ++i2) {
                newToOld[i2] = i2;
            }
            new InPlaceMergeSorter(){

                @Override
                protected void swap(int i2, int j2) {
                    int tmp = newToOld[i2];
                    newToOld[i2] = newToOld[j2];
                    newToOld[j2] = tmp;
                }

                @Override
                protected int compare(int i2, int j2) {
                    return Long.compare(weights[newToOld[j2]], weights[newToOld[i2]]);
                }
            }.sort(0, weights.length);
            return newToOld;
        }

        private static int[] inverse(int[] map) {
            int[] inverse = new int[map.length];
            for (int i2 = 0; i2 < map.length; ++i2) {
                inverse[map[i2]] = i2;
            }
            return inverse;
        }

        SegmentMap(long[] weights) {
            this.newToOld = SegmentMap.map(weights);
            this.oldToNew = SegmentMap.inverse(this.newToOld);
            assert (Arrays.equals(this.newToOld, SegmentMap.inverse(this.oldToNew)));
        }

        int newToOld(int segment) {
            return this.newToOld[segment];
        }

        int oldToNew(int segment) {
            return this.oldToNew[segment];
        }

        @Override
        public long ramBytesUsed() {
            return BASE_RAM_BYTES_USED + RamUsageEstimator.sizeOf(this.newToOld) + RamUsageEstimator.sizeOf(this.oldToNew);
        }
    }

    private static class TermsEnumIndex {
        public static final TermsEnumIndex[] EMPTY_ARRAY = new TermsEnumIndex[0];
        final int subIndex;
        final TermsEnum termsEnum;
        BytesRef currentTerm;

        public TermsEnumIndex(TermsEnum termsEnum, int subIndex) {
            this.termsEnum = termsEnum;
            this.subIndex = subIndex;
        }

        public BytesRef next() throws IOException {
            this.currentTerm = this.termsEnum.next();
            return this.currentTerm;
        }
    }
}

