/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queries.function.valuesource;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.queries.function.FunctionValues;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.lucene.queries.function.docvalues.BoolDocValues;
import org.apache.lucene.queries.function.valuesource.BoolFunction;
import org.apache.lucene.search.IndexSearcher;

public abstract class ComparisonBoolFunction
extends BoolFunction {
    private final ValueSource lhs;
    private final ValueSource rhs;
    private final String name;

    public ComparisonBoolFunction(ValueSource lhs, ValueSource rhs, String name) {
        this.lhs = lhs;
        this.rhs = rhs;
        this.name = name;
    }

    public abstract boolean compare(int var1, FunctionValues var2, FunctionValues var3) throws IOException;

    public String name() {
        return this.name;
    }

    @Override
    public FunctionValues getValues(Map context, LeafReaderContext readerContext) throws IOException {
        final FunctionValues lhsVal = this.lhs.getValues(context, readerContext);
        final FunctionValues rhsVal = this.rhs.getValues(context, readerContext);
        final String compLabel = this.name();
        return new BoolDocValues(this){

            @Override
            public boolean boolVal(int doc) throws IOException {
                return ComparisonBoolFunction.this.compare(doc, lhsVal, rhsVal);
            }

            @Override
            public String toString(int doc) throws IOException {
                return compLabel + "(" + lhsVal.toString(doc) + "," + rhsVal.toString(doc) + ")";
            }

            @Override
            public boolean exists(int doc) throws IOException {
                return lhsVal.exists(doc) && rhsVal.exists(doc);
            }
        };
    }

    @Override
    public boolean equals(Object o2) {
        if (this.getClass() != o2.getClass()) {
            return false;
        }
        ComparisonBoolFunction other = (ComparisonBoolFunction)o2;
        return this.name().equals(other.name()) && this.lhs.equals(other.lhs) && this.rhs.equals(other.rhs);
    }

    @Override
    public int hashCode() {
        int h2 = this.getClass().hashCode();
        h2 = h2 * 31 + this.name().hashCode();
        h2 = h2 * 31 + this.lhs.hashCode();
        h2 = h2 * 31 + this.rhs.hashCode();
        return h2;
    }

    @Override
    public String description() {
        return this.name() + "(" + this.lhs.description() + "," + this.rhs.description() + ")";
    }

    @Override
    public void createWeight(Map context, IndexSearcher searcher) throws IOException {
        this.lhs.createWeight(context, searcher);
        this.rhs.createWeight(context, searcher);
    }
}

