/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queries.function.valuesource;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.queries.function.FunctionValues;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.lucene.queries.function.valuesource.QueryDocValues;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Weight;

public class QueryValueSource
extends ValueSource {
    final Query q;
    final float defVal;

    public QueryValueSource(Query q2, float defVal) {
        this.q = q2;
        this.defVal = defVal;
    }

    public Query getQuery() {
        return this.q;
    }

    public float getDefaultValue() {
        return this.defVal;
    }

    @Override
    public String description() {
        return "query(" + this.q + ",def=" + this.defVal + ")";
    }

    @Override
    public FunctionValues getValues(Map fcontext, LeafReaderContext readerContext) throws IOException {
        return new QueryDocValues(this, readerContext, fcontext);
    }

    @Override
    public int hashCode() {
        return this.q.hashCode() * 29;
    }

    @Override
    public boolean equals(Object o2) {
        if (QueryValueSource.class != o2.getClass()) {
            return false;
        }
        QueryValueSource other = (QueryValueSource)o2;
        return this.q.equals(other.q) && this.defVal == other.defVal;
    }

    @Override
    public void createWeight(Map context, IndexSearcher searcher) throws IOException {
        Weight w2 = searcher.createNormalizedWeight(this.q, true);
        context.put(this, w2);
    }
}

