/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queryparser.classic;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.BoostQuery;
import org.apache.lucene.search.MultiPhraseQuery;
import org.apache.lucene.search.PhraseQuery;
import org.apache.lucene.search.Query;

public class MultiFieldQueryParser
extends QueryParser {
    protected String[] fields;
    protected Map<String, Float> boosts;

    public MultiFieldQueryParser(String[] fields, Analyzer analyzer, Map<String, Float> boosts) {
        this(fields, analyzer);
        this.boosts = boosts;
    }

    public MultiFieldQueryParser(String[] fields, Analyzer analyzer) {
        super(null, analyzer);
        this.fields = fields;
    }

    @Override
    protected Query getFieldQuery(String field, String queryText, int slop) throws ParseException {
        if (field == null) {
            ArrayList<Query> clauses = new ArrayList<Query>();
            for (int i2 = 0; i2 < this.fields.length; ++i2) {
                Float boost;
                Query q2 = super.getFieldQuery(this.fields[i2], queryText, true);
                if (q2 == null) continue;
                if (this.boosts != null && (boost = this.boosts.get(this.fields[i2])) != null) {
                    q2 = new BoostQuery(q2, boost.floatValue());
                }
                q2 = this.applySlop(q2, slop);
                clauses.add(q2);
            }
            if (clauses.size() == 0) {
                return null;
            }
            return this.getMultiFieldQuery(clauses);
        }
        Query q3 = super.getFieldQuery(field, queryText, true);
        q3 = this.applySlop(q3, slop);
        return q3;
    }

    private Query applySlop(Query q2, int slop) {
        MultiPhraseQuery mpq;
        if (q2 instanceof PhraseQuery) {
            PhraseQuery.Builder builder = new PhraseQuery.Builder();
            builder.setSlop(slop);
            PhraseQuery pq = (PhraseQuery)q2;
            Term[] terms = pq.getTerms();
            int[] positions = pq.getPositions();
            for (int i2 = 0; i2 < terms.length; ++i2) {
                builder.add(terms[i2], positions[i2]);
            }
            q2 = builder.build();
        } else if (q2 instanceof MultiPhraseQuery && slop != (mpq = (MultiPhraseQuery)q2).getSlop()) {
            q2 = new MultiPhraseQuery.Builder(mpq).setSlop(slop).build();
        }
        return q2;
    }

    @Override
    protected Query getFieldQuery(String field, String queryText, boolean quoted) throws ParseException {
        if (field == null) {
            ArrayList<Query> clauses = new ArrayList<Query>();
            Query[] fieldQueries = new Query[this.fields.length];
            int maxTerms = 0;
            for (int i2 = 0; i2 < this.fields.length; ++i2) {
                Query q2 = super.getFieldQuery(this.fields[i2], queryText, quoted);
                if (q2 == null) continue;
                maxTerms = q2 instanceof BooleanQuery ? Math.max(maxTerms, ((BooleanQuery)q2).clauses().size()) : Math.max(1, maxTerms);
                fieldQueries[i2] = q2;
            }
            for (int termNum = 0; termNum < maxTerms; ++termNum) {
                ArrayList<Query> termClauses = new ArrayList<Query>();
                for (int i3 = 0; i3 < this.fields.length; ++i3) {
                    Float boost;
                    if (fieldQueries[i3] == null) continue;
                    Query q3 = null;
                    if (fieldQueries[i3] instanceof BooleanQuery) {
                        List<BooleanClause> nestedClauses = ((BooleanQuery)fieldQueries[i3]).clauses();
                        if (termNum < nestedClauses.size()) {
                            q3 = nestedClauses.get(termNum).getQuery();
                        }
                    } else if (termNum == 0) {
                        q3 = fieldQueries[i3];
                    }
                    if (q3 == null) continue;
                    if (this.boosts != null && (boost = this.boosts.get(this.fields[i3])) != null) {
                        q3 = new BoostQuery(q3, boost.floatValue());
                    }
                    termClauses.add(q3);
                }
                if (maxTerms > 1) {
                    if (termClauses.size() <= 0) continue;
                    BooleanQuery.Builder builder = this.newBooleanQuery();
                    for (Query termClause : termClauses) {
                        builder.add(termClause, BooleanClause.Occur.SHOULD);
                    }
                    clauses.add(builder.build());
                    continue;
                }
                clauses.addAll(termClauses);
            }
            if (clauses.size() == 0) {
                return null;
            }
            return this.getMultiFieldQuery(clauses);
        }
        Query q4 = super.getFieldQuery(field, queryText, quoted);
        return q4;
    }

    @Override
    protected Query getFuzzyQuery(String field, String termStr, float minSimilarity) throws ParseException {
        if (field == null) {
            ArrayList<Query> clauses = new ArrayList<Query>();
            for (int i2 = 0; i2 < this.fields.length; ++i2) {
                clauses.add(this.getFuzzyQuery(this.fields[i2], termStr, minSimilarity));
            }
            return this.getMultiFieldQuery(clauses);
        }
        return super.getFuzzyQuery(field, termStr, minSimilarity);
    }

    @Override
    protected Query getPrefixQuery(String field, String termStr) throws ParseException {
        if (field == null) {
            ArrayList<Query> clauses = new ArrayList<Query>();
            for (int i2 = 0; i2 < this.fields.length; ++i2) {
                clauses.add(this.getPrefixQuery(this.fields[i2], termStr));
            }
            return this.getMultiFieldQuery(clauses);
        }
        return super.getPrefixQuery(field, termStr);
    }

    @Override
    protected Query getWildcardQuery(String field, String termStr) throws ParseException {
        if (field == null) {
            ArrayList<Query> clauses = new ArrayList<Query>();
            for (int i2 = 0; i2 < this.fields.length; ++i2) {
                clauses.add(this.getWildcardQuery(this.fields[i2], termStr));
            }
            return this.getMultiFieldQuery(clauses);
        }
        return super.getWildcardQuery(field, termStr);
    }

    @Override
    protected Query getRangeQuery(String field, String part1, String part2, boolean startInclusive, boolean endInclusive) throws ParseException {
        if (field == null) {
            ArrayList<Query> clauses = new ArrayList<Query>();
            for (int i2 = 0; i2 < this.fields.length; ++i2) {
                clauses.add(this.getRangeQuery(this.fields[i2], part1, part2, startInclusive, endInclusive));
            }
            return this.getMultiFieldQuery(clauses);
        }
        return super.getRangeQuery(field, part1, part2, startInclusive, endInclusive);
    }

    @Override
    protected Query getRegexpQuery(String field, String termStr) throws ParseException {
        if (field == null) {
            ArrayList<Query> clauses = new ArrayList<Query>();
            for (int i2 = 0; i2 < this.fields.length; ++i2) {
                clauses.add(this.getRegexpQuery(this.fields[i2], termStr));
            }
            return this.getMultiFieldQuery(clauses);
        }
        return super.getRegexpQuery(field, termStr);
    }

    protected Query getMultiFieldQuery(List<Query> queries) throws ParseException {
        if (queries.isEmpty()) {
            return null;
        }
        BooleanQuery.Builder query = this.newBooleanQuery();
        for (Query sub : queries) {
            query.add(sub, BooleanClause.Occur.SHOULD);
        }
        return query.build();
    }

    public static Query parse(String[] queries, String[] fields, Analyzer analyzer) throws ParseException {
        if (queries.length != fields.length) {
            throw new IllegalArgumentException("queries.length != fields.length");
        }
        BooleanQuery.Builder bQuery = new BooleanQuery.Builder();
        for (int i2 = 0; i2 < fields.length; ++i2) {
            QueryParser qp = new QueryParser(fields[i2], analyzer);
            Query q2 = qp.parse(queries[i2]);
            if (q2 == null || q2 instanceof BooleanQuery && ((BooleanQuery)q2).clauses().size() <= 0) continue;
            bQuery.add(q2, BooleanClause.Occur.SHOULD);
        }
        return bQuery.build();
    }

    public static Query parse(String query, String[] fields, BooleanClause.Occur[] flags, Analyzer analyzer) throws ParseException {
        if (fields.length != flags.length) {
            throw new IllegalArgumentException("fields.length != flags.length");
        }
        BooleanQuery.Builder bQuery = new BooleanQuery.Builder();
        for (int i2 = 0; i2 < fields.length; ++i2) {
            QueryParser qp = new QueryParser(fields[i2], analyzer);
            Query q2 = qp.parse(query);
            if (q2 == null || q2 instanceof BooleanQuery && ((BooleanQuery)q2).clauses().size() <= 0) continue;
            bQuery.add(q2, flags[i2]);
        }
        return bQuery.build();
    }

    public static Query parse(String[] queries, String[] fields, BooleanClause.Occur[] flags, Analyzer analyzer) throws ParseException {
        if (queries.length != fields.length || queries.length != flags.length) {
            throw new IllegalArgumentException("queries, fields, and flags array have have different length");
        }
        BooleanQuery.Builder bQuery = new BooleanQuery.Builder();
        for (int i2 = 0; i2 < fields.length; ++i2) {
            QueryParser qp = new QueryParser(fields[i2], analyzer);
            Query q2 = qp.parse(queries[i2]);
            if (q2 == null || q2 instanceof BooleanQuery && ((BooleanQuery)q2).clauses().size() <= 0) continue;
            bQuery.add(q2, flags[i2]);
        }
        return bQuery.build();
    }
}

