/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queryparser.surround.query;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryparser.surround.query.BasicQueryFactory;
import org.apache.lucene.search.MatchNoDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.spans.SpanBoostQuery;
import org.apache.lucene.search.spans.SpanOrQuery;
import org.apache.lucene.search.spans.SpanQuery;
import org.apache.lucene.search.spans.SpanTermQuery;

public class SpanNearClauseFactory {
    private IndexReader reader;
    private String fieldName;
    private HashMap<SpanQuery, Float> weightBySpanQuery;
    private BasicQueryFactory qf;

    public SpanNearClauseFactory(IndexReader reader, String fieldName, BasicQueryFactory qf) {
        this.reader = reader;
        this.fieldName = fieldName;
        this.weightBySpanQuery = new HashMap();
        this.qf = qf;
    }

    public IndexReader getIndexReader() {
        return this.reader;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public BasicQueryFactory getBasicQueryFactory() {
        return this.qf;
    }

    public int size() {
        return this.weightBySpanQuery.size();
    }

    public void clear() {
        this.weightBySpanQuery.clear();
    }

    protected void addSpanQueryWeighted(SpanQuery sq, float weight) {
        Float w2 = this.weightBySpanQuery.get(sq);
        w2 = w2 != null ? Float.valueOf(w2.floatValue() + weight) : Float.valueOf(weight);
        this.weightBySpanQuery.put(sq, w2);
    }

    public void addTermWeighted(Term t2, float weight) throws IOException {
        SpanTermQuery stq = this.qf.newSpanTermQuery(t2);
        this.addSpanQueryWeighted(stq, weight);
    }

    public void addSpanQuery(Query q2) {
        if (q2.getClass() == MatchNoDocsQuery.class) {
            return;
        }
        if (!(q2 instanceof SpanQuery)) {
            throw new AssertionError((Object)("Expected SpanQuery: " + q2.toString(this.getFieldName())));
        }
        float boost = 1.0f;
        if (q2 instanceof SpanBoostQuery) {
            SpanBoostQuery bq = (SpanBoostQuery)q2;
            boost = bq.getBoost();
            q2 = bq.getQuery();
        }
        this.addSpanQueryWeighted((SpanQuery)q2, boost);
    }

    public SpanQuery makeSpanClause() {
        SpanQuery[] spanQueries = new SpanQuery[this.size()];
        Iterator<SpanQuery> sqi = this.weightBySpanQuery.keySet().iterator();
        int i2 = 0;
        while (sqi.hasNext()) {
            SpanQuery sq = sqi.next();
            float boost = this.weightBySpanQuery.get(sq).floatValue();
            if (boost != 1.0f) {
                sq = new SpanBoostQuery(sq, boost);
            }
            spanQueries[i2++] = sq;
        }
        if (spanQueries.length == 1) {
            return spanQueries[0];
        }
        return new SpanOrQuery(spanQueries);
    }
}

