/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queryparser.surround.query;

import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.MultiFields;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.queryparser.surround.query.SimpleTerm;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.StringHelper;

public class SrndTruncQuery
extends SimpleTerm {
    private final String truncated;
    private final char unlimited;
    private final char mask;
    private String prefix;
    private BytesRef prefixRef;
    private Pattern pattern;

    public SrndTruncQuery(String truncated, char unlimited, char mask) {
        super(false);
        this.truncated = truncated;
        this.unlimited = unlimited;
        this.mask = mask;
        this.truncatedToPrefixAndPattern();
    }

    public String getTruncated() {
        return this.truncated;
    }

    @Override
    public String toStringUnquoted() {
        return this.getTruncated();
    }

    protected boolean matchingChar(char c2) {
        return c2 != this.unlimited && c2 != this.mask;
    }

    protected void appendRegExpForChar(char c2, StringBuilder re) {
        if (c2 == this.unlimited) {
            re.append(".*");
        } else if (c2 == this.mask) {
            re.append(".");
        } else {
            re.append(c2);
        }
    }

    protected void truncatedToPrefixAndPattern() {
        int i2;
        for (i2 = 0; i2 < this.truncated.length() && this.matchingChar(this.truncated.charAt(i2)); ++i2) {
        }
        this.prefix = this.truncated.substring(0, i2);
        this.prefixRef = new BytesRef(this.prefix);
        StringBuilder re = new StringBuilder();
        while (i2 < this.truncated.length()) {
            this.appendRegExpForChar(this.truncated.charAt(i2), re);
            ++i2;
        }
        this.pattern = Pattern.compile(re.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void visitMatchingTerms(IndexReader reader, String fieldName, SimpleTerm.MatchingTermVisitor mtv) throws IOException {
        int prefixLength = this.prefix.length();
        Terms terms = MultiFields.getTerms(reader, fieldName);
        if (terms != null) {
            Matcher matcher = this.pattern.matcher("");
            try {
                TermsEnum termsEnum = terms.iterator();
                TermsEnum.SeekStatus status = termsEnum.seekCeil(this.prefixRef);
                BytesRef text = status == TermsEnum.SeekStatus.FOUND ? this.prefixRef : (status == TermsEnum.SeekStatus.NOT_FOUND ? termsEnum.term() : null);
                while (text != null && text != null && StringHelper.startsWith(text, this.prefixRef)) {
                    String textString = text.utf8ToString();
                    matcher.reset(textString.substring(prefixLength));
                    if (matcher.matches()) {
                        mtv.visitMatchingTerm(new Term(fieldName, textString));
                    }
                    text = termsEnum.next();
                }
            }
            finally {
                matcher.reset();
            }
        }
    }
}

