/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queryparser.xml.builders;

import org.apache.lucene.queryparser.xml.DOMUtils;
import org.apache.lucene.queryparser.xml.ParserException;
import org.apache.lucene.queryparser.xml.QueryBuilder;
import org.apache.lucene.queryparser.xml.QueryBuilderFactory;
import org.apache.lucene.search.BoostQuery;
import org.apache.lucene.search.ConstantScoreQuery;
import org.apache.lucene.search.Query;
import org.w3c.dom.Element;

public class ConstantScoreQueryBuilder
implements QueryBuilder {
    private final QueryBuilderFactory queryFactory;

    public ConstantScoreQueryBuilder(QueryBuilderFactory queryFactory) {
        this.queryFactory = queryFactory;
    }

    @Override
    public Query getQuery(Element e2) throws ParserException {
        Element queryElem = DOMUtils.getFirstChildOrFail(e2);
        Query q2 = new ConstantScoreQuery(this.queryFactory.getQuery(queryElem));
        float boost = DOMUtils.getAttribute(e2, "boost", 1.0f);
        if (boost != 1.0f) {
            q2 = new BoostQuery(q2, boost);
        }
        return q2;
    }
}

