/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queryparser.xml.builders;

import java.util.ArrayList;
import org.apache.lucene.queryparser.xml.DOMUtils;
import org.apache.lucene.queryparser.xml.ParserException;
import org.apache.lucene.queryparser.xml.QueryBuilder;
import org.apache.lucene.search.BoostQuery;
import org.apache.lucene.search.DisjunctionMaxQuery;
import org.apache.lucene.search.Query;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DisjunctionMaxQueryBuilder
implements QueryBuilder {
    private final QueryBuilder factory;

    public DisjunctionMaxQueryBuilder(QueryBuilder factory) {
        this.factory = factory;
    }

    @Override
    public Query getQuery(Element e2) throws ParserException {
        float tieBreaker = DOMUtils.getAttribute(e2, "tieBreaker", 0.0f);
        ArrayList<Query> disjuncts = new ArrayList<Query>();
        NodeList nl = e2.getChildNodes();
        int nlLen = nl.getLength();
        for (int i2 = 0; i2 < nlLen; ++i2) {
            Node node = nl.item(i2);
            if (!(node instanceof Element)) continue;
            Element queryElem = (Element)node;
            Query q2 = this.factory.getQuery(queryElem);
            disjuncts.add(q2);
        }
        Query q3 = new DisjunctionMaxQuery(disjuncts, tieBreaker);
        float boost = DOMUtils.getAttribute(e2, "boost", 1.0f);
        if (boost != 1.0f) {
            q3 = new BoostQuery(q3, boost);
        }
        return q3;
    }
}

