/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexReaderContext;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermContext;
import org.apache.lucene.index.TermState;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.BoostQuery;
import org.apache.lucene.search.DisjunctionMaxQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.InPlaceMergeSorter;

public final class BlendedTermQuery
extends Query {
    public static final RewriteMethod BOOLEAN_REWRITE = new RewriteMethod(){

        @Override
        public Query rewrite(Query[] subQueries) {
            BooleanQuery.Builder merged = new BooleanQuery.Builder();
            for (Query query : subQueries) {
                merged.add(query, BooleanClause.Occur.SHOULD);
            }
            return merged.build();
        }
    };
    public static final RewriteMethod DISJUNCTION_MAX_REWRITE = new DisjunctionMaxRewrite(0.01f);
    private final Term[] terms;
    private final float[] boosts;
    private final TermContext[] contexts;
    private final RewriteMethod rewriteMethod;

    private BlendedTermQuery(final Term[] terms, final float[] boosts, final TermContext[] contexts, RewriteMethod rewriteMethod) {
        assert (terms.length == boosts.length);
        assert (terms.length == contexts.length);
        this.terms = terms;
        this.boosts = boosts;
        this.contexts = contexts;
        this.rewriteMethod = rewriteMethod;
        new InPlaceMergeSorter(){

            @Override
            protected void swap(int i2, int j2) {
                Term tmpTerm = terms[i2];
                terms[i2] = terms[j2];
                terms[j2] = tmpTerm;
                TermContext tmpContext = contexts[i2];
                contexts[i2] = contexts[j2];
                contexts[j2] = tmpContext;
                float tmpBoost = boosts[i2];
                boosts[i2] = boosts[j2];
                boosts[j2] = tmpBoost;
            }

            @Override
            protected int compare(int i2, int j2) {
                return terms[i2].compareTo(terms[j2]);
            }
        }.sort(0, terms.length);
    }

    @Override
    public boolean equals(Object other) {
        return this.sameClassAs(other) && this.equalsTo((BlendedTermQuery)this.getClass().cast(other));
    }

    private boolean equalsTo(BlendedTermQuery other) {
        return Arrays.equals(this.terms, other.terms) && Arrays.equals(this.contexts, other.contexts) && Arrays.equals(this.boosts, other.boosts) && this.rewriteMethod.equals(other.rewriteMethod);
    }

    @Override
    public int hashCode() {
        int h2 = this.classHash();
        h2 = 31 * h2 + Arrays.hashCode(this.terms);
        h2 = 31 * h2 + Arrays.hashCode(this.contexts);
        h2 = 31 * h2 + Arrays.hashCode(this.boosts);
        h2 = 31 * h2 + this.rewriteMethod.hashCode();
        return h2;
    }

    @Override
    public String toString(String field) {
        StringBuilder builder = new StringBuilder("Blended(");
        for (int i2 = 0; i2 < this.terms.length; ++i2) {
            if (i2 != 0) {
                builder.append(" ");
            }
            Query termQuery = new TermQuery(this.terms[i2]);
            if (this.boosts[i2] != 1.0f) {
                termQuery = new BoostQuery(termQuery, this.boosts[i2]);
            }
            builder.append(((Query)termQuery).toString(field));
        }
        builder.append(")");
        return builder.toString();
    }

    @Override
    public final Query rewrite(IndexReader reader) throws IOException {
        TermContext[] contexts = Arrays.copyOf(this.contexts, this.contexts.length);
        for (int i2 = 0; i2 < contexts.length; ++i2) {
            if (contexts[i2] != null && contexts[i2].wasBuiltFor(reader.getContext())) continue;
            contexts[i2] = TermContext.build(reader.getContext(), this.terms[i2]);
        }
        int df = 0;
        long ttf = 0L;
        for (TermContext ctx : contexts) {
            df = Math.max(df, ctx.docFreq());
            if (ctx.totalTermFreq() == -1L) {
                ttf = -1L;
                continue;
            }
            if (ttf == -1L) continue;
            ttf += ctx.totalTermFreq();
        }
        for (int i3 = 0; i3 < contexts.length; ++i3) {
            contexts[i3] = BlendedTermQuery.adjustFrequencies(reader.getContext(), contexts[i3], df, ttf);
        }
        Query[] termQueries = new Query[this.terms.length];
        for (int i4 = 0; i4 < this.terms.length; ++i4) {
            termQueries[i4] = new TermQuery(this.terms[i4], contexts[i4]);
            if (this.boosts[i4] == 1.0f) continue;
            termQueries[i4] = new BoostQuery(termQueries[i4], this.boosts[i4]);
        }
        return this.rewriteMethod.rewrite(termQueries);
    }

    private static TermContext adjustFrequencies(IndexReaderContext readerContext, TermContext ctx, int artificialDf, long artificialTtf) {
        List<LeafReaderContext> leaves = readerContext.leaves();
        int len = leaves == null ? 1 : leaves.size();
        TermContext newCtx = new TermContext(readerContext);
        for (int i2 = 0; i2 < len; ++i2) {
            TermState termState = ctx.get(i2);
            if (termState == null) continue;
            newCtx.register(termState, i2);
        }
        newCtx.accumulateStatistics(artificialDf, artificialTtf);
        return newCtx;
    }

    public static class DisjunctionMaxRewrite
    extends RewriteMethod {
        private final float tieBreakerMultiplier;

        public DisjunctionMaxRewrite(float tieBreakerMultiplier) {
            this.tieBreakerMultiplier = tieBreakerMultiplier;
        }

        @Override
        public Query rewrite(Query[] subQueries) {
            return new DisjunctionMaxQuery(Arrays.asList(subQueries), this.tieBreakerMultiplier);
        }

        public boolean equals(Object obj) {
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            DisjunctionMaxRewrite that = (DisjunctionMaxRewrite)obj;
            return this.tieBreakerMultiplier == that.tieBreakerMultiplier;
        }

        public int hashCode() {
            return 31 * this.getClass().hashCode() + Float.floatToIntBits(this.tieBreakerMultiplier);
        }
    }

    public static abstract class RewriteMethod {
        protected RewriteMethod() {
        }

        public abstract Query rewrite(Query[] var1);
    }

    public static class Builder {
        private int numTerms = 0;
        private Term[] terms = new Term[0];
        private float[] boosts = new float[0];
        private TermContext[] contexts = new TermContext[0];
        private RewriteMethod rewriteMethod = DISJUNCTION_MAX_REWRITE;

        public Builder setRewriteMethod(RewriteMethod rewiteMethod) {
            this.rewriteMethod = rewiteMethod;
            return this;
        }

        public Builder add(Term term) {
            return this.add(term, 1.0f);
        }

        public Builder add(Term term, float boost) {
            return this.add(term, boost, null);
        }

        public Builder add(Term term, float boost, TermContext context) {
            if (this.numTerms >= BooleanQuery.getMaxClauseCount()) {
                throw new BooleanQuery.TooManyClauses();
            }
            this.terms = ArrayUtil.grow(this.terms, this.numTerms + 1);
            this.boosts = ArrayUtil.grow(this.boosts, this.numTerms + 1);
            this.contexts = ArrayUtil.grow(this.contexts, this.numTerms + 1);
            this.terms[this.numTerms] = term;
            this.boosts[this.numTerms] = boost;
            this.contexts[this.numTerms] = context;
            ++this.numTerms;
            return this;
        }

        public BlendedTermQuery build() {
            return new BlendedTermQuery(Arrays.copyOf(this.terms, this.numTerms), Arrays.copyOf(this.boosts, this.numTerms), Arrays.copyOf(this.contexts, this.numTerms), this.rewriteMethod);
        }
    }
}

