/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.util.Arrays;
import java.util.Iterator;
import org.apache.lucene.search.DisiWrapper;

public final class DisiPriorityQueue
implements Iterable<DisiWrapper> {
    private final DisiWrapper[] heap;
    private int size;

    static int leftNode(int node) {
        return (node + 1 << 1) - 1;
    }

    static int rightNode(int leftNode) {
        return leftNode + 1;
    }

    static int parentNode(int node) {
        return (node + 1 >>> 1) - 1;
    }

    public DisiPriorityQueue(int maxSize) {
        this.heap = new DisiWrapper[maxSize];
        this.size = 0;
    }

    public int size() {
        return this.size;
    }

    public DisiWrapper top() {
        return this.heap[0];
    }

    public DisiWrapper topList() {
        DisiWrapper[] heap = this.heap;
        int size = this.size;
        DisiWrapper list = heap[0];
        list.next = null;
        if (size >= 3) {
            list = this.topList(list, heap, size, 1);
            list = this.topList(list, heap, size, 2);
        } else if (size == 2 && heap[1].doc == list.doc) {
            list = this.prepend(heap[1], list);
        }
        return list;
    }

    private DisiWrapper prepend(DisiWrapper w1, DisiWrapper w2) {
        w1.next = w2;
        return w1;
    }

    private DisiWrapper topList(DisiWrapper list, DisiWrapper[] heap, int size, int i2) {
        DisiWrapper w2 = heap[i2];
        if (w2.doc == list.doc) {
            list = this.prepend(w2, list);
            int left = DisiPriorityQueue.leftNode(i2);
            int right = left + 1;
            if (right < size) {
                list = this.topList(list, heap, size, left);
                list = this.topList(list, heap, size, right);
            } else if (left < size && heap[left].doc == list.doc) {
                list = this.prepend(heap[left], list);
            }
        }
        return list;
    }

    public DisiWrapper add(DisiWrapper entry) {
        DisiWrapper[] heap = this.heap;
        int size = this.size;
        heap[size] = entry;
        this.upHeap(size);
        this.size = size + 1;
        return heap[0];
    }

    public DisiWrapper pop() {
        DisiWrapper[] heap = this.heap;
        DisiWrapper result = heap[0];
        int i2 = --this.size;
        heap[0] = heap[i2];
        heap[i2] = null;
        this.downHeap(i2);
        return result;
    }

    public DisiWrapper updateTop() {
        this.downHeap(this.size);
        return this.heap[0];
    }

    DisiWrapper updateTop(DisiWrapper topReplacement) {
        this.heap[0] = topReplacement;
        return this.updateTop();
    }

    void upHeap(int i2) {
        DisiWrapper node = this.heap[i2];
        int nodeDoc = node.doc;
        int j2 = DisiPriorityQueue.parentNode(i2);
        while (j2 >= 0 && nodeDoc < this.heap[j2].doc) {
            this.heap[i2] = this.heap[j2];
            i2 = j2;
            j2 = DisiPriorityQueue.parentNode(j2);
        }
        this.heap[i2] = node;
    }

    void downHeap(int size) {
        int i2 = 0;
        DisiWrapper node = this.heap[0];
        int j2 = DisiPriorityQueue.leftNode(i2);
        if (j2 < size) {
            int k2 = DisiPriorityQueue.rightNode(j2);
            if (k2 < size && this.heap[k2].doc < this.heap[j2].doc) {
                j2 = k2;
            }
            if (this.heap[j2].doc < node.doc) {
                do {
                    this.heap[i2] = this.heap[j2];
                    i2 = j2;
                    k2 = DisiPriorityQueue.rightNode(j2 = DisiPriorityQueue.leftNode(i2));
                    if (k2 >= size || this.heap[k2].doc >= this.heap[j2].doc) continue;
                    j2 = k2;
                } while (j2 < size && this.heap[j2].doc < node.doc);
                this.heap[i2] = node;
            }
        }
    }

    @Override
    public Iterator<DisiWrapper> iterator() {
        return Arrays.asList(this.heap).subList(0, this.size).iterator();
    }
}

