/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.lucene.search.DisiPriorityQueue;
import org.apache.lucene.search.DisiWrapper;
import org.apache.lucene.search.DisjunctionDISIApproximation;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.TwoPhaseIterator;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.PriorityQueue;

abstract class DisjunctionScorer
extends Scorer {
    private final boolean needsScores;
    private final DisiPriorityQueue subScorers;
    private final DisjunctionDISIApproximation approximation;
    private final TwoPhase twoPhase;

    protected DisjunctionScorer(Weight weight, List<Scorer> subScorers, boolean needsScores) {
        super(weight);
        if (subScorers.size() <= 1) {
            throw new IllegalArgumentException("There must be at least 2 subScorers");
        }
        this.subScorers = new DisiPriorityQueue(subScorers.size());
        for (Scorer scorer : subScorers) {
            DisiWrapper w2 = new DisiWrapper(scorer);
            this.subScorers.add(w2);
        }
        this.needsScores = needsScores;
        this.approximation = new DisjunctionDISIApproximation(this.subScorers);
        boolean hasApproximation = false;
        float sumMatchCost = 0.0f;
        long sumApproxCost = 0L;
        for (DisiWrapper w3 : this.subScorers) {
            long costWeight = w3.cost <= 1L ? 1L : w3.cost;
            sumApproxCost += costWeight;
            if (w3.twoPhaseView == null) continue;
            hasApproximation = true;
            sumMatchCost += w3.matchCost * (float)costWeight;
        }
        if (!hasApproximation) {
            this.twoPhase = null;
        } else {
            float matchCost = sumMatchCost / (float)sumApproxCost;
            this.twoPhase = new TwoPhase(this.approximation, matchCost);
        }
    }

    @Override
    public DocIdSetIterator iterator() {
        if (this.twoPhase != null) {
            return TwoPhaseIterator.asDocIdSetIterator(this.twoPhase);
        }
        return this.approximation;
    }

    @Override
    public TwoPhaseIterator twoPhaseIterator() {
        return this.twoPhase;
    }

    @Override
    public final int docID() {
        return this.subScorers.top().doc;
    }

    DisiWrapper getSubMatches() throws IOException {
        if (this.twoPhase == null) {
            return this.subScorers.topList();
        }
        return this.twoPhase.getSubMatches();
    }

    @Override
    public final float score() throws IOException {
        return this.score(this.getSubMatches());
    }

    protected abstract float score(DisiWrapper var1) throws IOException;

    @Override
    public final Collection<Scorer.ChildScorer> getChildren() throws IOException {
        ArrayList<Scorer.ChildScorer> children = new ArrayList<Scorer.ChildScorer>();
        DisiWrapper scorer = this.getSubMatches();
        while (scorer != null) {
            children.add(new Scorer.ChildScorer(scorer.scorer, "SHOULD"));
            scorer = scorer.next;
        }
        return children;
    }

    private class TwoPhase
    extends TwoPhaseIterator {
        private final float matchCost;
        DisiWrapper verifiedMatches;
        final PriorityQueue<DisiWrapper> unverifiedMatches;

        private TwoPhase(DocIdSetIterator approximation, float matchCost) {
            super(approximation);
            this.matchCost = matchCost;
            this.unverifiedMatches = new PriorityQueue<DisiWrapper>(DisjunctionScorer.this.subScorers.size()){

                @Override
                protected boolean lessThan(DisiWrapper a2, DisiWrapper b2) {
                    return a2.matchCost < b2.matchCost;
                }
            };
        }

        DisiWrapper getSubMatches() throws IOException {
            for (DisiWrapper w2 : this.unverifiedMatches) {
                if (!w2.twoPhaseView.matches()) continue;
                w2.next = this.verifiedMatches;
                this.verifiedMatches = w2;
            }
            this.unverifiedMatches.clear();
            return this.verifiedMatches;
        }

        @Override
        public boolean matches() throws IOException {
            this.verifiedMatches = null;
            this.unverifiedMatches.clear();
            DisiWrapper w2 = DisjunctionScorer.this.subScorers.topList();
            while (w2 != null) {
                DisiWrapper next = w2.next;
                if (w2.twoPhaseView == null) {
                    w2.next = this.verifiedMatches;
                    this.verifiedMatches = w2;
                    if (!DisjunctionScorer.this.needsScores) {
                        return true;
                    }
                } else {
                    this.unverifiedMatches.add(w2);
                }
                w2 = next;
            }
            if (this.verifiedMatches != null) {
                return true;
            }
            while (this.unverifiedMatches.size() > 0) {
                w2 = this.unverifiedMatches.pop();
                if (!w2.twoPhaseView.matches()) continue;
                w2.next = null;
                this.verifiedMatches = w2;
                return true;
            }
            return false;
        }

        @Override
        public float matchCost() {
            return this.matchCost;
        }
    }
}

