/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.FieldComparator;
import org.apache.lucene.search.FieldDoc;
import org.apache.lucene.search.LeafFieldComparator;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.SortField;
import org.apache.lucene.util.PriorityQueue;

public abstract class FieldValueHitQueue<T extends Entry>
extends PriorityQueue<T> {
    protected final SortField[] fields;
    protected final FieldComparator<?>[] comparators;
    protected final int[] reverseMul;

    private FieldValueHitQueue(SortField[] fields, int size) {
        super(size);
        this.fields = fields;
        int numComparators = fields.length;
        this.comparators = new FieldComparator[numComparators];
        this.reverseMul = new int[numComparators];
        for (int i2 = 0; i2 < numComparators; ++i2) {
            SortField field = fields[i2];
            this.reverseMul[i2] = field.reverse ? -1 : 1;
            this.comparators[i2] = field.getComparator(size, i2);
        }
    }

    public static <T extends Entry> FieldValueHitQueue<T> create(SortField[] fields, int size) {
        if (fields.length == 0) {
            throw new IllegalArgumentException("Sort must contain at least one field");
        }
        if (fields.length == 1) {
            return new OneComparatorFieldValueHitQueue(fields, size);
        }
        return new MultiComparatorsFieldValueHitQueue(fields, size);
    }

    public FieldComparator<?>[] getComparators() {
        return this.comparators;
    }

    public int[] getReverseMul() {
        return this.reverseMul;
    }

    public LeafFieldComparator[] getComparators(LeafReaderContext context) throws IOException {
        LeafFieldComparator[] comparators = new LeafFieldComparator[this.comparators.length];
        for (int i2 = 0; i2 < comparators.length; ++i2) {
            comparators[i2] = this.comparators[i2].getLeafComparator(context);
        }
        return comparators;
    }

    @Override
    protected abstract boolean lessThan(Entry var1, Entry var2);

    FieldDoc fillFields(Entry entry) {
        int n2 = this.comparators.length;
        Object[] fields = new Object[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            fields[i2] = this.comparators[i2].value(entry.slot);
        }
        return new FieldDoc(entry.doc, entry.score, fields);
    }

    SortField[] getFields() {
        return this.fields;
    }

    private static final class MultiComparatorsFieldValueHitQueue<T extends Entry>
    extends FieldValueHitQueue<T> {
        public MultiComparatorsFieldValueHitQueue(SortField[] fields, int size) {
            super(fields, size);
        }

        @Override
        protected boolean lessThan(Entry hitA, Entry hitB) {
            assert (hitA != hitB);
            assert (hitA.slot != hitB.slot);
            int numComparators = this.comparators.length;
            for (int i2 = 0; i2 < numComparators; ++i2) {
                int c2 = this.reverseMul[i2] * this.comparators[i2].compare(hitA.slot, hitB.slot);
                if (c2 == 0) continue;
                return c2 > 0;
            }
            return hitA.doc > hitB.doc;
        }
    }

    private static final class OneComparatorFieldValueHitQueue<T extends Entry>
    extends FieldValueHitQueue<T> {
        private final int oneReverseMul;
        private final FieldComparator<?> oneComparator;

        public OneComparatorFieldValueHitQueue(SortField[] fields, int size) {
            super(fields, size);
            assert (fields.length == 1);
            this.oneComparator = this.comparators[0];
            this.oneReverseMul = this.reverseMul[0];
        }

        @Override
        protected boolean lessThan(Entry hitA, Entry hitB) {
            assert (hitA != hitB);
            assert (hitA.slot != hitB.slot);
            int c2 = this.oneReverseMul * this.oneComparator.compare(hitA.slot, hitB.slot);
            if (c2 != 0) {
                return c2 > 0;
            }
            return hitA.doc > hitB.doc;
        }
    }

    public static class Entry
    extends ScoreDoc {
        public int slot;

        public Entry(int slot, int doc, float score) {
            super(doc, score);
            this.slot = slot;
        }

        @Override
        public String toString() {
            return "slot:" + this.slot + " " + super.toString();
        }
    }
}

