/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexReaderContext;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.ReaderUtil;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermContext;
import org.apache.lucene.index.TermState;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MatchNoDocsQuery;
import org.apache.lucene.search.MultiPhraseQuery;
import org.apache.lucene.search.PhraseQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.TermAutomatonScorer;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TermStatistics;
import org.apache.lucene.search.Weight;
import org.apache.lucene.search.similarities.Similarity;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.IntsRef;
import org.apache.lucene.util.automaton.Automaton;
import org.apache.lucene.util.automaton.Operations;
import org.apache.lucene.util.automaton.Transition;

public class TermAutomatonQuery
extends Query {
    private final String field;
    private final Automaton.Builder builder;
    Automaton det;
    private final Map<BytesRef, Integer> termToID = new HashMap<BytesRef, Integer>();
    private final Map<Integer, BytesRef> idToTerm = new HashMap<Integer, BytesRef>();
    private int anyTermID = -1;

    public TermAutomatonQuery(String field) {
        this.field = field;
        this.builder = new Automaton.Builder();
    }

    public int createState() {
        return this.builder.createState();
    }

    public void setAccept(int state, boolean accept) {
        this.builder.setAccept(state, accept);
    }

    public void addTransition(int source, int dest, String term) {
        this.addTransition(source, dest, new BytesRef(term));
    }

    public void addTransition(int source, int dest, BytesRef term) {
        if (term == null) {
            throw new NullPointerException("term should not be null");
        }
        this.builder.addTransition(source, dest, this.getTermID(term));
    }

    public void addAnyTransition(int source, int dest) {
        this.builder.addTransition(source, dest, this.getTermID(null));
    }

    public void finish() {
        this.finish(10000);
    }

    public void finish(int maxDeterminizedStates) {
        Automaton automaton = this.builder.finish();
        Transition t2 = new Transition();
        if (this.anyTermID != -1) {
            int i2;
            int count = automaton.initTransition(0, t2);
            for (int i3 = 0; i3 < count; ++i3) {
                automaton.getNextTransition(t2);
                if (this.anyTermID < t2.min || this.anyTermID > t2.max) continue;
                throw new IllegalStateException("automaton cannot lead with an ANY transition");
            }
            int numStates = automaton.getNumStates();
            for (int i4 = 0; i4 < numStates; ++i4) {
                count = automaton.initTransition(i4, t2);
                for (int j2 = 0; j2 < count; ++j2) {
                    automaton.getNextTransition(t2);
                    if (!automaton.isAccept(t2.dest) || this.anyTermID < t2.min || this.anyTermID > t2.max) continue;
                    throw new IllegalStateException("automaton cannot end with an ANY transition");
                }
            }
            int termCount = this.termToID.size();
            Automaton newAutomaton = new Automaton();
            for (i2 = 0; i2 < numStates; ++i2) {
                newAutomaton.createState();
                newAutomaton.setAccept(i2, automaton.isAccept(i2));
            }
            for (i2 = 0; i2 < numStates; ++i2) {
                count = automaton.initTransition(i2, t2);
                for (int j3 = 0; j3 < count; ++j3) {
                    int max;
                    int min2;
                    automaton.getNextTransition(t2);
                    if (t2.min <= this.anyTermID && this.anyTermID <= t2.max) {
                        min2 = 0;
                        max = termCount - 1;
                    } else {
                        min2 = t2.min;
                        max = t2.max;
                    }
                    newAutomaton.addTransition(t2.source, t2.dest, min2, max);
                }
            }
            newAutomaton.finishState();
            automaton = newAutomaton;
        }
        this.det = Operations.removeDeadStates(Operations.determinize(automaton, maxDeterminizedStates));
        if (this.det.isAccept(0)) {
            throw new IllegalStateException("cannot accept the empty string");
        }
    }

    @Override
    public Weight createWeight(IndexSearcher searcher, boolean needsScores, float boost) throws IOException {
        IndexReaderContext context = searcher.getTopReaderContext();
        HashMap<Integer, TermContext> termStates = new HashMap<Integer, TermContext>();
        for (Map.Entry<BytesRef, Integer> ent : this.termToID.entrySet()) {
            if (ent.getKey() == null) continue;
            termStates.put(ent.getValue(), TermContext.build(context, new Term(this.field, ent.getKey())));
        }
        return new TermAutomatonWeight(this.det, searcher, termStates, boost);
    }

    @Override
    public String toString(String field) {
        StringBuilder sb = new StringBuilder();
        sb.append("TermAutomatonQuery(field=");
        sb.append(this.field);
        if (this.det != null) {
            sb.append(" numStates=");
            sb.append(this.det.getNumStates());
        }
        sb.append(')');
        return sb.toString();
    }

    private int getTermID(BytesRef term) {
        Integer id = this.termToID.get(term);
        if (id == null) {
            id = this.termToID.size();
            if (term != null) {
                term = BytesRef.deepCopyOf(term);
            }
            this.termToID.put(term, id);
            this.idToTerm.put(id, term);
            if (term == null) {
                this.anyTermID = id;
            }
        }
        return id;
    }

    @Override
    public boolean equals(Object other) {
        return this.sameClassAs(other) && this.equalsTo((TermAutomatonQuery)this.getClass().cast(other));
    }

    private static boolean checkFinished(TermAutomatonQuery q2) {
        if (q2.det == null) {
            throw new IllegalStateException("Call finish first on: " + q2);
        }
        return true;
    }

    private boolean equalsTo(TermAutomatonQuery other) {
        return TermAutomatonQuery.checkFinished(this) && TermAutomatonQuery.checkFinished(other) && other == this;
    }

    @Override
    public int hashCode() {
        TermAutomatonQuery.checkFinished(this);
        return System.identityHashCode(this);
    }

    public String toDot() {
        StringBuilder b2 = new StringBuilder();
        b2.append("digraph Automaton {\n");
        b2.append("  rankdir = LR\n");
        int numStates = this.det.getNumStates();
        if (numStates > 0) {
            b2.append("  initial [shape=plaintext,label=\"0\"]\n");
            b2.append("  initial -> 0\n");
        }
        Transition t2 = new Transition();
        for (int state = 0; state < numStates; ++state) {
            b2.append("  ");
            b2.append(state);
            if (this.det.isAccept(state)) {
                b2.append(" [shape=doublecircle,label=\"" + state + "\"]\n");
            } else {
                b2.append(" [shape=circle,label=\"" + state + "\"]\n");
            }
            int numTransitions = this.det.initTransition(state, t2);
            for (int i2 = 0; i2 < numTransitions; ++i2) {
                this.det.getNextTransition(t2);
                assert (t2.max >= t2.min);
                for (int j2 = t2.min; j2 <= t2.max; ++j2) {
                    b2.append("  ");
                    b2.append(state);
                    b2.append(" -> ");
                    b2.append(t2.dest);
                    b2.append(" [label=\"");
                    if (j2 == this.anyTermID) {
                        b2.append('*');
                    } else {
                        b2.append(this.idToTerm.get(j2).utf8ToString());
                    }
                    b2.append("\"]\n");
                }
            }
        }
        b2.append('}');
        return b2.toString();
    }

    @Override
    public Query rewrite(IndexReader reader) throws IOException {
        if (Operations.isEmpty(this.det)) {
            return new MatchNoDocsQuery();
        }
        IntsRef single = Operations.getSingleton(this.det);
        if (single != null && single.length == 1) {
            return new TermQuery(new Term(this.field, this.idToTerm.get(single.ints[single.offset])));
        }
        MultiPhraseQuery.Builder mpq = new MultiPhraseQuery.Builder();
        PhraseQuery.Builder pq = new PhraseQuery.Builder();
        Transition t2 = new Transition();
        int state = 0;
        int pos = 0;
        block0: while (true) {
            int count;
            if ((count = this.det.initTransition(state, t2)) == 0) {
                if (this.det.isAccept(state)) break;
                mpq = null;
                pq = null;
                break;
            }
            if (this.det.isAccept(state)) {
                mpq = null;
                pq = null;
                break;
            }
            int dest = -1;
            ArrayList<Term> terms = new ArrayList<Term>();
            boolean matchesAny = false;
            for (int i2 = 0; i2 < count; ++i2) {
                this.det.getNextTransition(t2);
                if (i2 == 0) {
                    dest = t2.dest;
                } else if (dest != t2.dest) {
                    mpq = null;
                    pq = null;
                    break block0;
                }
                if (matchesAny |= this.anyTermID >= t2.min && this.anyTermID <= t2.max) continue;
                for (int termID = t2.min; termID <= t2.max; ++termID) {
                    terms.add(new Term(this.field, this.idToTerm.get(termID)));
                }
            }
            if (!matchesAny) {
                mpq.add(terms.toArray(new Term[terms.size()]), pos);
                if (pq != null) {
                    if (terms.size() == 1) {
                        pq.add((Term)terms.get(0), pos);
                    } else {
                        pq = null;
                    }
                }
            }
            state = dest;
            ++pos;
        }
        if (pq != null) {
            return pq.build();
        }
        if (mpq != null) {
            return mpq.build();
        }
        return this;
    }

    final class TermAutomatonWeight
    extends Weight {
        final Automaton automaton;
        private final Map<Integer, TermContext> termStates;
        private final Similarity.SimWeight stats;
        private final Similarity similarity;

        public TermAutomatonWeight(Automaton automaton, IndexSearcher searcher, Map<Integer, TermContext> termStates, float boost) throws IOException {
            super(TermAutomatonQuery.this);
            this.automaton = automaton;
            this.termStates = termStates;
            this.similarity = searcher.getSimilarity(true);
            ArrayList<TermStatistics> allTermStats = new ArrayList<TermStatistics>();
            for (Map.Entry ent : TermAutomatonQuery.this.idToTerm.entrySet()) {
                Integer termID = (Integer)ent.getKey();
                if (ent.getValue() == null) continue;
                allTermStats.add(searcher.termStatistics(new Term(TermAutomatonQuery.this.field, (BytesRef)ent.getValue()), termStates.get(termID)));
            }
            this.stats = this.similarity.computeWeight(boost, searcher.collectionStatistics(TermAutomatonQuery.this.field), allTermStats.toArray(new TermStatistics[allTermStats.size()]));
        }

        @Override
        public void extractTerms(Set<Term> terms) {
            for (BytesRef text : TermAutomatonQuery.this.termToID.keySet()) {
                if (text == null) continue;
                terms.add(new Term(TermAutomatonQuery.this.field, text));
            }
        }

        public String toString() {
            return "weight(" + TermAutomatonQuery.this + ")";
        }

        @Override
        public Scorer scorer(LeafReaderContext context) throws IOException {
            EnumAndScorer[] enums = new EnumAndScorer[TermAutomatonQuery.this.idToTerm.size()];
            boolean any = false;
            for (Map.Entry<Integer, TermContext> ent : this.termStates.entrySet()) {
                TermContext termContext = ent.getValue();
                assert (termContext.wasBuiltFor(ReaderUtil.getTopLevelContext(context))) : "The top-reader used to create Weight is not the same as the current reader's top-reader (" + ReaderUtil.getTopLevelContext(context);
                BytesRef term = (BytesRef)TermAutomatonQuery.this.idToTerm.get(ent.getKey());
                TermState state = termContext.get(context.ord);
                if (state == null) continue;
                TermsEnum termsEnum = context.reader().terms(TermAutomatonQuery.this.field).iterator();
                termsEnum.seekExact(term, state);
                enums[ent.getKey().intValue()] = new EnumAndScorer(ent.getKey(), termsEnum.postings(null, 24));
                any = true;
            }
            if (any) {
                return new TermAutomatonScorer(this, enums, TermAutomatonQuery.this.anyTermID, TermAutomatonQuery.this.idToTerm, this.similarity.simScorer(this.stats, context));
            }
            return null;
        }

        @Override
        public boolean isCacheable(LeafReaderContext ctx) {
            return true;
        }

        @Override
        public Explanation explain(LeafReaderContext context, int doc) throws IOException {
            return null;
        }
    }

    static class EnumAndScorer {
        public final int termID;
        public final PostingsEnum posEnum;
        public int posLeft;
        public int pos;

        public EnumAndScorer(int termID, PostingsEnum posEnum) {
            this.termID = termID;
            this.posEnum = posEnum;
        }
    }
}

