/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.spans;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermContext;
import org.apache.lucene.search.CollectionStatistics;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.TermStatistics;
import org.apache.lucene.search.Weight;
import org.apache.lucene.search.similarities.Similarity;
import org.apache.lucene.search.spans.SpanQuery;
import org.apache.lucene.search.spans.SpanScorer;
import org.apache.lucene.search.spans.Spans;

public abstract class SpanWeight
extends Weight {
    protected final Similarity similarity;
    protected final Similarity.SimWeight simWeight;
    protected final String field;

    public SpanWeight(SpanQuery query, IndexSearcher searcher, Map<Term, TermContext> termContexts, float boost) throws IOException {
        super(query);
        this.field = query.getField();
        this.similarity = searcher.getSimilarity(termContexts != null);
        this.simWeight = this.buildSimWeight(query, searcher, termContexts, boost);
    }

    private Similarity.SimWeight buildSimWeight(SpanQuery query, IndexSearcher searcher, Map<Term, TermContext> termContexts, float boost) throws IOException {
        if (termContexts == null || termContexts.size() == 0 || query.getField() == null) {
            return null;
        }
        TermStatistics[] termStats = new TermStatistics[termContexts.size()];
        int i2 = 0;
        for (Term term : termContexts.keySet()) {
            termStats[i2] = searcher.termStatistics(term, termContexts.get(term));
            ++i2;
        }
        CollectionStatistics collectionStats = searcher.collectionStatistics(query.getField());
        return this.similarity.computeWeight(boost, collectionStats, termStats);
    }

    public abstract void extractTermContexts(Map<Term, TermContext> var1);

    public abstract Spans getSpans(LeafReaderContext var1, Postings var2) throws IOException;

    @Override
    public SpanScorer scorer(LeafReaderContext context) throws IOException {
        Spans spans = this.getSpans(context, Postings.POSITIONS);
        if (spans == null) {
            return null;
        }
        Similarity.SimScorer docScorer = this.getSimScorer(context);
        return new SpanScorer(this, spans, docScorer);
    }

    public Similarity.SimScorer getSimScorer(LeafReaderContext context) throws IOException {
        return this.simWeight == null ? null : this.similarity.simScorer(this.simWeight, context);
    }

    @Override
    public Explanation explain(LeafReaderContext context, int doc) throws IOException {
        int newDoc;
        SpanScorer scorer = this.scorer(context);
        if (scorer != null && (newDoc = scorer.iterator().advance(doc)) == doc) {
            float freq = scorer.sloppyFreq();
            Similarity.SimScorer docScorer = this.similarity.simScorer(this.simWeight, context);
            Explanation freqExplanation = Explanation.match(freq, "phraseFreq=" + freq, new Explanation[0]);
            Explanation scoreExplanation = docScorer.explain(doc, freqExplanation);
            return Explanation.match(scoreExplanation.getValue(), "weight(" + this.getQuery() + " in " + doc + ") [" + this.similarity.getClass().getSimpleName() + "], result of:", scoreExplanation);
        }
        return Explanation.noMatch("no matching term", new Explanation[0]);
    }

    public static enum Postings {
        POSITIONS{

            @Override
            public int getRequiredPostings() {
                return 24;
            }
        }
        ,
        PAYLOADS{

            @Override
            public int getRequiredPostings() {
                return 88;
            }
        }
        ,
        OFFSETS{

            @Override
            public int getRequiredPostings() {
                return 120;
            }
        };


        public abstract int getRequiredPostings();

        public Postings atLeast(Postings postings) {
            if (postings.compareTo(this) > 0) {
                return postings;
            }
            return this;
        }
    }
}

