/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.store;

import java.io.EOFException;
import java.io.IOException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import org.apache.lucene.store.AlreadyClosedException;
import org.apache.lucene.store.ByteBufferGuard;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.RandomAccessInput;

abstract class ByteBufferIndexInput
extends IndexInput
implements RandomAccessInput {
    protected final long length;
    protected final long chunkSizeMask;
    protected final int chunkSizePower;
    protected final ByteBufferGuard guard;
    protected ByteBuffer[] buffers;
    protected int curBufIndex = -1;
    protected ByteBuffer curBuf;
    protected boolean isClone = false;

    public static ByteBufferIndexInput newInstance(String resourceDescription, ByteBuffer[] buffers, long length, int chunkSizePower, ByteBufferGuard guard) {
        if (buffers.length == 1) {
            return new SingleBufferImpl(resourceDescription, buffers[0], length, chunkSizePower, guard);
        }
        return new MultiBufferImpl(resourceDescription, buffers, 0, length, chunkSizePower, guard);
    }

    ByteBufferIndexInput(String resourceDescription, ByteBuffer[] buffers, long length, int chunkSizePower, ByteBufferGuard guard) {
        super(resourceDescription);
        this.buffers = buffers;
        this.length = length;
        this.chunkSizePower = chunkSizePower;
        this.chunkSizeMask = (1L << chunkSizePower) - 1L;
        this.guard = guard;
        assert (chunkSizePower >= 0 && chunkSizePower <= 30);
        assert (length >>> chunkSizePower < Integer.MAX_VALUE);
    }

    @Override
    public final byte readByte() throws IOException {
        try {
            return this.guard.getByte(this.curBuf);
        }
        catch (BufferUnderflowException e2) {
            do {
                ++this.curBufIndex;
                if (this.curBufIndex >= this.buffers.length) {
                    throw new EOFException("read past EOF: " + this);
                }
                this.curBuf = this.buffers[this.curBufIndex];
                this.curBuf.position(0);
            } while (!this.curBuf.hasRemaining());
            return this.guard.getByte(this.curBuf);
        }
        catch (NullPointerException npe) {
            throw new AlreadyClosedException("Already closed: " + this);
        }
    }

    @Override
    public final void readBytes(byte[] b2, int offset, int len) throws IOException {
        try {
            this.guard.getBytes(this.curBuf, b2, offset, len);
        }
        catch (BufferUnderflowException e2) {
            int curAvail = this.curBuf.remaining();
            while (len > curAvail) {
                this.guard.getBytes(this.curBuf, b2, offset, curAvail);
                len -= curAvail;
                offset += curAvail;
                ++this.curBufIndex;
                if (this.curBufIndex >= this.buffers.length) {
                    throw new EOFException("read past EOF: " + this);
                }
                this.curBuf = this.buffers[this.curBufIndex];
                this.curBuf.position(0);
                curAvail = this.curBuf.remaining();
            }
            this.guard.getBytes(this.curBuf, b2, offset, len);
        }
        catch (NullPointerException npe) {
            throw new AlreadyClosedException("Already closed: " + this);
        }
    }

    @Override
    public final short readShort() throws IOException {
        try {
            return this.guard.getShort(this.curBuf);
        }
        catch (BufferUnderflowException e2) {
            return super.readShort();
        }
        catch (NullPointerException npe) {
            throw new AlreadyClosedException("Already closed: " + this);
        }
    }

    @Override
    public final int readInt() throws IOException {
        try {
            return this.guard.getInt(this.curBuf);
        }
        catch (BufferUnderflowException e2) {
            return super.readInt();
        }
        catch (NullPointerException npe) {
            throw new AlreadyClosedException("Already closed: " + this);
        }
    }

    @Override
    public final long readLong() throws IOException {
        try {
            return this.guard.getLong(this.curBuf);
        }
        catch (BufferUnderflowException e2) {
            return super.readLong();
        }
        catch (NullPointerException npe) {
            throw new AlreadyClosedException("Already closed: " + this);
        }
    }

    @Override
    public long getFilePointer() {
        try {
            return ((long)this.curBufIndex << this.chunkSizePower) + (long)this.curBuf.position();
        }
        catch (NullPointerException npe) {
            throw new AlreadyClosedException("Already closed: " + this);
        }
    }

    @Override
    public void seek(long pos) throws IOException {
        int bi = (int)(pos >> this.chunkSizePower);
        try {
            if (bi == this.curBufIndex) {
                this.curBuf.position((int)(pos & this.chunkSizeMask));
            } else {
                ByteBuffer b2 = this.buffers[bi];
                b2.position((int)(pos & this.chunkSizeMask));
                this.curBufIndex = bi;
                this.curBuf = b2;
            }
        }
        catch (ArrayIndexOutOfBoundsException | IllegalArgumentException e2) {
            throw new EOFException("seek past EOF: " + this);
        }
        catch (NullPointerException npe) {
            throw new AlreadyClosedException("Already closed: " + this);
        }
    }

    @Override
    public byte readByte(long pos) throws IOException {
        try {
            int bi = (int)(pos >> this.chunkSizePower);
            return this.guard.getByte(this.buffers[bi], (int)(pos & this.chunkSizeMask));
        }
        catch (IndexOutOfBoundsException ioobe) {
            throw new EOFException("seek past EOF: " + this);
        }
        catch (NullPointerException npe) {
            throw new AlreadyClosedException("Already closed: " + this);
        }
    }

    private void setPos(long pos, int bi) throws IOException {
        try {
            ByteBuffer b2 = this.buffers[bi];
            b2.position((int)(pos & this.chunkSizeMask));
            this.curBufIndex = bi;
            this.curBuf = b2;
        }
        catch (ArrayIndexOutOfBoundsException | IllegalArgumentException aioobe) {
            throw new EOFException("seek past EOF: " + this);
        }
        catch (NullPointerException npe) {
            throw new AlreadyClosedException("Already closed: " + this);
        }
    }

    @Override
    public short readShort(long pos) throws IOException {
        int bi = (int)(pos >> this.chunkSizePower);
        try {
            return this.guard.getShort(this.buffers[bi], (int)(pos & this.chunkSizeMask));
        }
        catch (IndexOutOfBoundsException ioobe) {
            this.setPos(pos, bi);
            return this.readShort();
        }
        catch (NullPointerException npe) {
            throw new AlreadyClosedException("Already closed: " + this);
        }
    }

    @Override
    public int readInt(long pos) throws IOException {
        int bi = (int)(pos >> this.chunkSizePower);
        try {
            return this.guard.getInt(this.buffers[bi], (int)(pos & this.chunkSizeMask));
        }
        catch (IndexOutOfBoundsException ioobe) {
            this.setPos(pos, bi);
            return this.readInt();
        }
        catch (NullPointerException npe) {
            throw new AlreadyClosedException("Already closed: " + this);
        }
    }

    @Override
    public long readLong(long pos) throws IOException {
        int bi = (int)(pos >> this.chunkSizePower);
        try {
            return this.guard.getLong(this.buffers[bi], (int)(pos & this.chunkSizeMask));
        }
        catch (IndexOutOfBoundsException ioobe) {
            this.setPos(pos, bi);
            return this.readLong();
        }
        catch (NullPointerException npe) {
            throw new AlreadyClosedException("Already closed: " + this);
        }
    }

    @Override
    public final long length() {
        return this.length;
    }

    @Override
    public final ByteBufferIndexInput clone() {
        ByteBufferIndexInput clone = this.buildSlice((String)null, 0L, this.length);
        try {
            clone.seek(this.getFilePointer());
        }
        catch (IOException ioe) {
            throw new AssertionError((Object)ioe);
        }
        return clone;
    }

    @Override
    public final ByteBufferIndexInput slice(String sliceDescription, long offset, long length) {
        if (offset < 0L || length < 0L || offset + length > this.length) {
            throw new IllegalArgumentException("slice() " + sliceDescription + " out of bounds: offset=" + offset + ",length=" + length + ",fileLength=" + this.length + ": " + this);
        }
        return this.buildSlice(sliceDescription, offset, length);
    }

    protected ByteBufferIndexInput buildSlice(String sliceDescription, long offset, long length) {
        if (this.buffers == null) {
            throw new AlreadyClosedException("Already closed: " + this);
        }
        ByteBuffer[] newBuffers = this.buildSlice(this.buffers, offset, length);
        int ofs = (int)(offset & this.chunkSizeMask);
        ByteBufferIndexInput clone = this.newCloneInstance(this.getFullSliceDescription(sliceDescription), newBuffers, ofs, length);
        clone.isClone = true;
        return clone;
    }

    protected ByteBufferIndexInput newCloneInstance(String newResourceDescription, ByteBuffer[] newBuffers, int offset, long length) {
        if (newBuffers.length == 1) {
            newBuffers[0].position(offset);
            return new SingleBufferImpl(newResourceDescription, newBuffers[0].slice(), length, this.chunkSizePower, this.guard);
        }
        return new MultiBufferImpl(newResourceDescription, newBuffers, offset, length, this.chunkSizePower, this.guard);
    }

    private ByteBuffer[] buildSlice(ByteBuffer[] buffers, long offset, long length) {
        long sliceEnd = offset + length;
        int startIndex = (int)(offset >>> this.chunkSizePower);
        int endIndex = (int)(sliceEnd >>> this.chunkSizePower);
        ByteBuffer[] slices = new ByteBuffer[endIndex - startIndex + 1];
        for (int i2 = 0; i2 < slices.length; ++i2) {
            slices[i2] = buffers[startIndex + i2].duplicate();
        }
        slices[slices.length - 1].limit((int)(sliceEnd & this.chunkSizeMask));
        return slices;
    }

    @Override
    public final void close() throws IOException {
        try {
            if (this.buffers == null) {
                return;
            }
            ByteBuffer[] bufs = this.buffers;
            this.unsetBuffers();
            if (this.isClone) {
                return;
            }
            this.guard.invalidateAndUnmap(bufs);
        }
        finally {
            this.unsetBuffers();
        }
    }

    private void unsetBuffers() {
        this.buffers = null;
        this.curBuf = null;
        this.curBufIndex = 0;
    }

    static final class MultiBufferImpl
    extends ByteBufferIndexInput {
        private final int offset;

        MultiBufferImpl(String resourceDescription, ByteBuffer[] buffers, int offset, long length, int chunkSizePower, ByteBufferGuard guard) {
            super(resourceDescription, buffers, length, chunkSizePower, guard);
            this.offset = offset;
            try {
                this.seek(0L);
            }
            catch (IOException ioe) {
                throw new AssertionError((Object)ioe);
            }
        }

        @Override
        public void seek(long pos) throws IOException {
            assert (pos >= 0L);
            super.seek(pos + (long)this.offset);
        }

        @Override
        public long getFilePointer() {
            return super.getFilePointer() - (long)this.offset;
        }

        @Override
        public byte readByte(long pos) throws IOException {
            return super.readByte(pos + (long)this.offset);
        }

        @Override
        public short readShort(long pos) throws IOException {
            return super.readShort(pos + (long)this.offset);
        }

        @Override
        public int readInt(long pos) throws IOException {
            return super.readInt(pos + (long)this.offset);
        }

        @Override
        public long readLong(long pos) throws IOException {
            return super.readLong(pos + (long)this.offset);
        }

        @Override
        protected ByteBufferIndexInput buildSlice(String sliceDescription, long ofs, long length) {
            return super.buildSlice(sliceDescription, (long)this.offset + ofs, length);
        }
    }

    static final class SingleBufferImpl
    extends ByteBufferIndexInput {
        SingleBufferImpl(String resourceDescription, ByteBuffer buffer, long length, int chunkSizePower, ByteBufferGuard guard) {
            super(resourceDescription, new ByteBuffer[]{buffer}, length, chunkSizePower, guard);
            this.curBufIndex = 0;
            this.curBuf = buffer;
            buffer.position(0);
        }

        @Override
        public void seek(long pos) throws IOException {
            try {
                this.curBuf.position((int)pos);
            }
            catch (IllegalArgumentException e2) {
                if (pos < 0L) {
                    throw new IllegalArgumentException("Seeking to negative position: " + this, e2);
                }
                throw new EOFException("seek past EOF: " + this);
            }
            catch (NullPointerException npe) {
                throw new AlreadyClosedException("Already closed: " + this);
            }
        }

        @Override
        public long getFilePointer() {
            try {
                return this.curBuf.position();
            }
            catch (NullPointerException npe) {
                throw new AlreadyClosedException("Already closed: " + this);
            }
        }

        @Override
        public byte readByte(long pos) throws IOException {
            try {
                return this.guard.getByte(this.curBuf, (int)pos);
            }
            catch (IllegalArgumentException e2) {
                if (pos < 0L) {
                    throw new IllegalArgumentException("Seeking to negative position: " + this, e2);
                }
                throw new EOFException("seek past EOF: " + this);
            }
            catch (NullPointerException npe) {
                throw new AlreadyClosedException("Already closed: " + this);
            }
        }

        @Override
        public short readShort(long pos) throws IOException {
            try {
                return this.guard.getShort(this.curBuf, (int)pos);
            }
            catch (IllegalArgumentException e2) {
                if (pos < 0L) {
                    throw new IllegalArgumentException("Seeking to negative position: " + this, e2);
                }
                throw new EOFException("seek past EOF: " + this);
            }
            catch (NullPointerException npe) {
                throw new AlreadyClosedException("Already closed: " + this);
            }
        }

        @Override
        public int readInt(long pos) throws IOException {
            try {
                return this.guard.getInt(this.curBuf, (int)pos);
            }
            catch (IllegalArgumentException e2) {
                if (pos < 0L) {
                    throw new IllegalArgumentException("Seeking to negative position: " + this, e2);
                }
                throw new EOFException("seek past EOF: " + this);
            }
            catch (NullPointerException npe) {
                throw new AlreadyClosedException("Already closed: " + this);
            }
        }

        @Override
        public long readLong(long pos) throws IOException {
            try {
                return this.guard.getLong(this.curBuf, (int)pos);
            }
            catch (IllegalArgumentException e2) {
                if (pos < 0L) {
                    throw new IllegalArgumentException("Seeking to negative position: " + this, e2);
                }
                throw new EOFException("seek past EOF: " + this);
            }
            catch (NullPointerException npe) {
                throw new AlreadyClosedException("Already closed: " + this);
            }
        }
    }
}

