/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.store;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.lucene.util.BitUtil;

public abstract class DataInput
implements Cloneable {
    private static final int SKIP_BUFFER_SIZE = 1024;
    private byte[] skipBuffer;

    public abstract byte readByte() throws IOException;

    public abstract void readBytes(byte[] var1, int var2, int var3) throws IOException;

    public void readBytes(byte[] b2, int offset, int len, boolean useBuffer) throws IOException {
        this.readBytes(b2, offset, len);
    }

    public short readShort() throws IOException {
        return (short)((this.readByte() & 0xFF) << 8 | this.readByte() & 0xFF);
    }

    public int readInt() throws IOException {
        return (this.readByte() & 0xFF) << 24 | (this.readByte() & 0xFF) << 16 | (this.readByte() & 0xFF) << 8 | this.readByte() & 0xFF;
    }

    public int readVInt() throws IOException {
        byte b2 = this.readByte();
        if (b2 >= 0) {
            return b2;
        }
        int i2 = b2 & 0x7F;
        b2 = this.readByte();
        i2 |= (b2 & 0x7F) << 7;
        if (b2 >= 0) {
            return i2;
        }
        b2 = this.readByte();
        i2 |= (b2 & 0x7F) << 14;
        if (b2 >= 0) {
            return i2;
        }
        b2 = this.readByte();
        i2 |= (b2 & 0x7F) << 21;
        if (b2 >= 0) {
            return i2;
        }
        b2 = this.readByte();
        i2 |= (b2 & 0xF) << 28;
        if ((b2 & 0xF0) == 0) {
            return i2;
        }
        throw new IOException("Invalid vInt detected (too many bits)");
    }

    public int readZInt() throws IOException {
        return BitUtil.zigZagDecode(this.readVInt());
    }

    public long readLong() throws IOException {
        return (long)this.readInt() << 32 | (long)this.readInt() & 0xFFFFFFFFL;
    }

    public long readVLong() throws IOException {
        return this.readVLong(false);
    }

    private long readVLong(boolean allowNegative) throws IOException {
        byte b2 = this.readByte();
        if (b2 >= 0) {
            return b2;
        }
        long i2 = (long)b2 & 0x7FL;
        b2 = this.readByte();
        i2 |= ((long)b2 & 0x7FL) << 7;
        if (b2 >= 0) {
            return i2;
        }
        b2 = this.readByte();
        i2 |= ((long)b2 & 0x7FL) << 14;
        if (b2 >= 0) {
            return i2;
        }
        b2 = this.readByte();
        i2 |= ((long)b2 & 0x7FL) << 21;
        if (b2 >= 0) {
            return i2;
        }
        b2 = this.readByte();
        i2 |= ((long)b2 & 0x7FL) << 28;
        if (b2 >= 0) {
            return i2;
        }
        b2 = this.readByte();
        i2 |= ((long)b2 & 0x7FL) << 35;
        if (b2 >= 0) {
            return i2;
        }
        b2 = this.readByte();
        i2 |= ((long)b2 & 0x7FL) << 42;
        if (b2 >= 0) {
            return i2;
        }
        b2 = this.readByte();
        i2 |= ((long)b2 & 0x7FL) << 49;
        if (b2 >= 0) {
            return i2;
        }
        b2 = this.readByte();
        i2 |= ((long)b2 & 0x7FL) << 56;
        if (b2 >= 0) {
            return i2;
        }
        if (allowNegative) {
            b2 = this.readByte();
            i2 |= ((long)b2 & 0x7FL) << 63;
            if (b2 == 0 || b2 == 1) {
                return i2;
            }
            throw new IOException("Invalid vLong detected (more than 64 bits)");
        }
        throw new IOException("Invalid vLong detected (negative values disallowed)");
    }

    public long readZLong() throws IOException {
        return BitUtil.zigZagDecode(this.readVLong(true));
    }

    public String readString() throws IOException {
        int length = this.readVInt();
        byte[] bytes = new byte[length];
        this.readBytes(bytes, 0, length);
        return new String(bytes, 0, length, StandardCharsets.UTF_8);
    }

    public DataInput clone() {
        try {
            return (DataInput)super.clone();
        }
        catch (CloneNotSupportedException e2) {
            throw new Error("This cannot happen: Failing to clone DataInput");
        }
    }

    public Map<String, String> readMapOfStrings() throws IOException {
        int count = this.readVInt();
        if (count == 0) {
            return Collections.emptyMap();
        }
        if (count == 1) {
            return Collections.singletonMap(this.readString(), this.readString());
        }
        AbstractMap map = count > 10 ? new HashMap() : new TreeMap();
        for (int i2 = 0; i2 < count; ++i2) {
            String key = this.readString();
            String val = this.readString();
            map.put(key, val);
        }
        return Collections.unmodifiableMap(map);
    }

    public Set<String> readSetOfStrings() throws IOException {
        int count = this.readVInt();
        if (count == 0) {
            return Collections.emptySet();
        }
        if (count == 1) {
            return Collections.singleton(this.readString());
        }
        AbstractSet set = count > 10 ? new HashSet() : new TreeSet();
        for (int i2 = 0; i2 < count; ++i2) {
            set.add(this.readString());
        }
        return Collections.unmodifiableSet(set);
    }

    public void skipBytes(long numBytes) throws IOException {
        int step;
        if (numBytes < 0L) {
            throw new IllegalArgumentException("numBytes must be >= 0, got " + numBytes);
        }
        if (this.skipBuffer == null) {
            this.skipBuffer = new byte[1024];
        }
        assert (this.skipBuffer.length == 1024);
        for (long skipped = 0L; skipped < numBytes; skipped += (long)step) {
            step = (int)Math.min(1024L, numBytes - skipped);
            this.readBytes(this.skipBuffer, 0, step, false);
        }
    }
}

