/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.store;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Random;
import org.apache.lucene.store.FSLockFactory;
import org.apache.lucene.store.Lock;
import org.apache.lucene.store.LockFactory;
import org.apache.lucene.store.LockObtainFailedException;
import org.apache.lucene.store.NoLockFactory;
import org.apache.lucene.store.SimpleFSDirectory;
import org.apache.lucene.store.VerifyingLockFactory;
import org.apache.lucene.util.SuppressForbidden;

public class LockStressTest {
    static final String LOCK_FILE_NAME = "test.lock";

    @SuppressForbidden(reason="System.out required: command line tool")
    public static void main(String[] args) throws Exception {
        int myID;
        if (args.length != 7) {
            System.out.println("Usage: java org.apache.lucene.store.LockStressTest myID verifierHost verifierPort lockFactoryClassName lockDirName sleepTimeMS count\n\n  myID = int from 0 .. 255 (should be unique for test process)\n  verifierHost = hostname that LockVerifyServer is listening on\n  verifierPort = port that LockVerifyServer is listening on\n  lockFactoryClassName = primary FSLockFactory class that we will use\n  lockDirName = path to the lock directory\n  sleepTimeMS = milliseconds to pause betweeen each lock obtain/release\n  count = number of locking tries\n\nYou should run multiple instances of this process, each with its own\nunique ID, and each pointing to the same lock directory, to verify\nthat locking is working correctly.\n\nMake sure you are first running LockVerifyServer.");
            System.exit(1);
        }
        int arg = 0;
        if ((myID = Integer.parseInt(args[arg++])) < 0 || myID > 255) {
            System.out.println("myID must be a unique int 0..255");
            System.exit(1);
        }
        String verifierHost = args[arg++];
        int verifierPort = Integer.parseInt(args[arg++]);
        String lockFactoryClassName = args[arg++];
        Path lockDirPath = Paths.get(args[arg++], new String[0]);
        int sleepTimeMS = Integer.parseInt(args[arg++]);
        int count = Integer.parseInt(args[arg++]);
        FSLockFactory lockFactory = LockStressTest.getNewLockFactory(lockFactoryClassName);
        SimpleFSDirectory lockDir = new SimpleFSDirectory(lockDirPath, NoLockFactory.INSTANCE);
        InetSocketAddress addr = new InetSocketAddress(verifierHost, verifierPort);
        System.out.println("Connecting to server " + addr + " and registering as client " + myID + "...");
        try (Socket socket = new Socket();){
            socket.setReuseAddress(true);
            socket.connect(addr, 500);
            OutputStream out = socket.getOutputStream();
            InputStream in = socket.getInputStream();
            out.write(myID);
            out.flush();
            VerifyingLockFactory verifyLF = new VerifyingLockFactory(lockFactory, in, out);
            Random rnd = new Random();
            if (in.read() != 43) {
                throw new IOException("Protocol violation");
            }
            for (int i2 = 0; i2 < count; ++i2) {
                try (Lock l2 = ((LockFactory)verifyLF).obtainLock(lockDir, LOCK_FILE_NAME);){
                    if (rnd.nextInt(10) == 0) {
                        if (rnd.nextBoolean()) {
                            verifyLF = new VerifyingLockFactory(LockStressTest.getNewLockFactory(lockFactoryClassName), in, out);
                        }
                        try {
                            Lock secondLock = ((LockFactory)verifyLF).obtainLock(lockDir, LOCK_FILE_NAME);
                            Throwable throwable = null;
                            try {
                                try {
                                    throw new IOException("Double obtain");
                                }
                                catch (Throwable throwable2) {
                                    throwable = throwable2;
                                    throw throwable2;
                                }
                            }
                            catch (Throwable throwable3) {
                                if (secondLock != null) {
                                    if (throwable != null) {
                                        try {
                                            secondLock.close();
                                        }
                                        catch (Throwable throwable4) {
                                            throwable.addSuppressed(throwable4);
                                        }
                                    } else {
                                        secondLock.close();
                                    }
                                }
                                throw throwable3;
                            }
                        }
                        catch (LockObtainFailedException lockObtainFailedException) {
                            // empty catch block
                        }
                    }
                    Thread.sleep(sleepTimeMS);
                }
                catch (LockObtainFailedException lockObtainFailedException) {
                    // empty catch block
                }
                if (i2 % 500 == 0) {
                    System.out.println((double)i2 * 100.0 / (double)count + "% done.");
                }
                Thread.sleep(sleepTimeMS);
            }
        }
        System.out.println("Finished " + count + " tries.");
    }

    private static FSLockFactory getNewLockFactory(String lockFactoryClassName) throws IOException {
        try {
            return (FSLockFactory)Class.forName(lockFactoryClassName).getField("INSTANCE").get(null);
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            try {
                return Class.forName(lockFactoryClassName).asSubclass(FSLockFactory.class).newInstance();
            }
            catch (ClassCastException | ReflectiveOperationException exception) {
                throw new IOException("Cannot get lock factory singleton of " + lockFactoryClassName);
            }
        }
    }
}

