/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.store;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.CRC32;
import java.util.zip.CheckedOutputStream;
import org.apache.lucene.store.IndexOutput;

public class OutputStreamIndexOutput
extends IndexOutput {
    private final CRC32 crc = new CRC32();
    private final BufferedOutputStream os;
    private long bytesWritten = 0L;
    private boolean flushedOnClose = false;

    public OutputStreamIndexOutput(String resourceDescription, String name, OutputStream out, int bufferSize) {
        super(resourceDescription, name);
        this.os = new BufferedOutputStream(new CheckedOutputStream(out, this.crc), bufferSize);
    }

    @Override
    public final void writeByte(byte b2) throws IOException {
        this.os.write(b2);
        ++this.bytesWritten;
    }

    @Override
    public final void writeBytes(byte[] b2, int offset, int length) throws IOException {
        this.os.write(b2, offset, length);
        this.bytesWritten += (long)length;
    }

    @Override
    public void close() throws IOException {
        try (BufferedOutputStream o2 = this.os;){
            if (!this.flushedOnClose) {
                this.flushedOnClose = true;
                ((OutputStream)o2).flush();
            }
        }
    }

    @Override
    public final long getFilePointer() {
        return this.bytesWritten;
    }

    @Override
    public final long getChecksum() throws IOException {
        this.os.flush();
        return this.crc.getValue();
    }
}

