/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.store;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.zip.CRC32;
import java.util.zip.Checksum;
import org.apache.lucene.store.BufferedChecksum;
import org.apache.lucene.store.DataOutput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.store.RAMFile;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.Accountables;

public class RAMOutputStream
extends IndexOutput
implements Accountable {
    static final int BUFFER_SIZE = 1024;
    private final RAMFile file;
    private byte[] currentBuffer;
    private int currentBufferIndex;
    private int bufferPosition;
    private long bufferStart;
    private int bufferLength;
    private final Checksum crc;

    public RAMOutputStream() {
        this("noname", new RAMFile(), false);
    }

    public RAMOutputStream(RAMFile f2, boolean checksum) {
        this("noname", f2, checksum);
    }

    public RAMOutputStream(String name, RAMFile f2, boolean checksum) {
        super("RAMOutputStream(name=\"" + name + "\")", name);
        this.file = f2;
        this.currentBufferIndex = -1;
        this.currentBuffer = null;
        this.crc = checksum ? new BufferedChecksum(new CRC32()) : null;
    }

    public void writeTo(DataOutput out) throws IOException {
        this.flush();
        long end = this.file.length;
        long pos = 0L;
        int buffer = 0;
        while (pos < end) {
            int length = 1024;
            long nextPos = pos + (long)length;
            if (nextPos > end) {
                length = (int)(end - pos);
            }
            out.writeBytes(this.file.getBuffer(buffer++), length);
            pos = nextPos;
        }
    }

    public void writeTo(byte[] bytes, int offset) throws IOException {
        this.flush();
        long end = this.file.length;
        long pos = 0L;
        int buffer = 0;
        int bytesUpto = offset;
        while (pos < end) {
            int length = 1024;
            long nextPos = pos + (long)length;
            if (nextPos > end) {
                length = (int)(end - pos);
            }
            System.arraycopy(this.file.getBuffer(buffer++), 0, bytes, bytesUpto, length);
            bytesUpto += length;
            pos = nextPos;
        }
    }

    public void reset() {
        this.currentBuffer = null;
        this.currentBufferIndex = -1;
        this.bufferPosition = 0;
        this.bufferStart = 0L;
        this.bufferLength = 0;
        this.file.setLength(0L);
        if (this.crc != null) {
            this.crc.reset();
        }
    }

    @Override
    public void close() throws IOException {
        this.flush();
    }

    @Override
    public void writeByte(byte b2) throws IOException {
        if (this.bufferPosition == this.bufferLength) {
            ++this.currentBufferIndex;
            this.switchCurrentBuffer();
        }
        if (this.crc != null) {
            this.crc.update(b2);
        }
        this.currentBuffer[this.bufferPosition++] = b2;
    }

    @Override
    public void writeBytes(byte[] b2, int offset, int len) throws IOException {
        assert (b2 != null);
        if (this.crc != null) {
            this.crc.update(b2, offset, len);
        }
        while (len > 0) {
            int remainInBuffer;
            if (this.bufferPosition == this.bufferLength) {
                ++this.currentBufferIndex;
                this.switchCurrentBuffer();
            }
            int bytesToCopy = len < (remainInBuffer = this.currentBuffer.length - this.bufferPosition) ? len : remainInBuffer;
            System.arraycopy(b2, offset, this.currentBuffer, this.bufferPosition, bytesToCopy);
            offset += bytesToCopy;
            len -= bytesToCopy;
            this.bufferPosition += bytesToCopy;
        }
    }

    private final void switchCurrentBuffer() {
        this.currentBuffer = this.currentBufferIndex == this.file.numBuffers() ? this.file.addBuffer(1024) : this.file.getBuffer(this.currentBufferIndex);
        this.bufferPosition = 0;
        this.bufferStart = 1024L * (long)this.currentBufferIndex;
        this.bufferLength = this.currentBuffer.length;
    }

    private void setFileLength() {
        long pointer = this.bufferStart + (long)this.bufferPosition;
        if (pointer > this.file.length) {
            this.file.setLength(pointer);
        }
    }

    protected void flush() throws IOException {
        this.setFileLength();
    }

    @Override
    public long getFilePointer() {
        return this.currentBufferIndex < 0 ? 0L : this.bufferStart + (long)this.bufferPosition;
    }

    @Override
    public long ramBytesUsed() {
        return (long)this.file.numBuffers() * 1024L;
    }

    @Override
    public Collection<Accountable> getChildResources() {
        return Collections.singleton(Accountables.namedAccountable("file", this.file));
    }

    @Override
    public long getChecksum() throws IOException {
        if (this.crc == null) {
            throw new IllegalStateException("internal RAMOutputStream created with checksum disabled");
        }
        return this.crc.getValue();
    }
}

