/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util;

import java.util.Arrays;
import java.util.Comparator;
import org.apache.lucene.util.ArrayIntroSorter;
import org.apache.lucene.util.ArrayTimSorter;
import org.apache.lucene.util.Constants;
import org.apache.lucene.util.IntroSelector;
import org.apache.lucene.util.RamUsageEstimator;

public final class ArrayUtil {
    public static final int MAX_ARRAY_LENGTH = Integer.MAX_VALUE - RamUsageEstimator.NUM_BYTES_ARRAY_HEADER;

    private ArrayUtil() {
    }

    public static int parseInt(char[] chars, int offset, int len) throws NumberFormatException {
        return ArrayUtil.parseInt(chars, offset, len, 10);
    }

    public static int parseInt(char[] chars, int offset, int len, int radix) throws NumberFormatException {
        boolean negative;
        if (chars == null || radix < 2 || radix > 36) {
            throw new NumberFormatException();
        }
        int i2 = 0;
        if (len == 0) {
            throw new NumberFormatException("chars length is 0");
        }
        boolean bl = negative = chars[offset + i2] == '-';
        if (negative && ++i2 == len) {
            throw new NumberFormatException("can't convert to an int");
        }
        if (negative) {
            ++offset;
            --len;
        }
        return ArrayUtil.parse(chars, offset, len, radix, negative);
    }

    private static int parse(char[] chars, int offset, int len, int radix, boolean negative) throws NumberFormatException {
        int max = Integer.MIN_VALUE / radix;
        int result = 0;
        for (int i2 = 0; i2 < len; ++i2) {
            int digit = Character.digit(chars[i2 + offset], radix);
            if (digit == -1) {
                throw new NumberFormatException("Unable to parse");
            }
            if (max > result) {
                throw new NumberFormatException("Unable to parse");
            }
            int next = result * radix - digit;
            if (next > result) {
                throw new NumberFormatException("Unable to parse");
            }
            result = next;
        }
        if (!negative && (result = -result) < 0) {
            throw new NumberFormatException("Unable to parse");
        }
        return result;
    }

    public static int oversize(int minTargetSize, int bytesPerElement) {
        int newSize;
        if (minTargetSize < 0) {
            throw new IllegalArgumentException("invalid array size " + minTargetSize);
        }
        if (minTargetSize == 0) {
            return 0;
        }
        if (minTargetSize > MAX_ARRAY_LENGTH) {
            throw new IllegalArgumentException("requested array size " + minTargetSize + " exceeds maximum array in java (" + MAX_ARRAY_LENGTH + ")");
        }
        int extra = minTargetSize >> 3;
        if (extra < 3) {
            extra = 3;
        }
        if ((newSize = minTargetSize + extra) + 7 < 0 || newSize + 7 > MAX_ARRAY_LENGTH) {
            return MAX_ARRAY_LENGTH;
        }
        if (Constants.JRE_IS_64BIT) {
            switch (bytesPerElement) {
                case 4: {
                    return newSize + 1 & 0x7FFFFFFE;
                }
                case 2: {
                    return newSize + 3 & 0x7FFFFFFC;
                }
                case 1: {
                    return newSize + 7 & 0x7FFFFFF8;
                }
            }
            return newSize;
        }
        switch (bytesPerElement) {
            case 2: {
                return newSize + 1 & 0x7FFFFFFE;
            }
            case 1: {
                return newSize + 3 & 0x7FFFFFFC;
            }
        }
        return newSize;
    }

    public static <T> T[] grow(T[] array, int minSize) {
        assert (minSize >= 0) : "size must be positive (got " + minSize + "): likely integer overflow?";
        if (array.length < minSize) {
            return Arrays.copyOf(array, ArrayUtil.oversize(minSize, RamUsageEstimator.NUM_BYTES_OBJECT_REF));
        }
        return array;
    }

    public static short[] grow(short[] array, int minSize) {
        assert (minSize >= 0) : "size must be positive (got " + minSize + "): likely integer overflow?";
        if (array.length < minSize) {
            return Arrays.copyOf(array, ArrayUtil.oversize(minSize, 2));
        }
        return array;
    }

    public static short[] grow(short[] array) {
        return ArrayUtil.grow(array, 1 + array.length);
    }

    public static float[] grow(float[] array, int minSize) {
        assert (minSize >= 0) : "size must be positive (got " + minSize + "): likely integer overflow?";
        if (array.length < minSize) {
            return Arrays.copyOf(array, ArrayUtil.oversize(minSize, 4));
        }
        return array;
    }

    public static float[] grow(float[] array) {
        return ArrayUtil.grow(array, 1 + array.length);
    }

    public static double[] grow(double[] array, int minSize) {
        assert (minSize >= 0) : "size must be positive (got " + minSize + "): likely integer overflow?";
        if (array.length < minSize) {
            return Arrays.copyOf(array, ArrayUtil.oversize(minSize, 8));
        }
        return array;
    }

    public static double[] grow(double[] array) {
        return ArrayUtil.grow(array, 1 + array.length);
    }

    public static int[] grow(int[] array, int minSize) {
        assert (minSize >= 0) : "size must be positive (got " + minSize + "): likely integer overflow?";
        if (array.length < minSize) {
            return Arrays.copyOf(array, ArrayUtil.oversize(minSize, 4));
        }
        return array;
    }

    public static int[] grow(int[] array) {
        return ArrayUtil.grow(array, 1 + array.length);
    }

    public static long[] grow(long[] array, int minSize) {
        assert (minSize >= 0) : "size must be positive (got " + minSize + "): likely integer overflow?";
        if (array.length < minSize) {
            return Arrays.copyOf(array, ArrayUtil.oversize(minSize, 8));
        }
        return array;
    }

    public static long[] grow(long[] array) {
        return ArrayUtil.grow(array, 1 + array.length);
    }

    public static byte[] grow(byte[] array, int minSize) {
        assert (minSize >= 0) : "size must be positive (got " + minSize + "): likely integer overflow?";
        if (array.length < minSize) {
            return Arrays.copyOf(array, ArrayUtil.oversize(minSize, 1));
        }
        return array;
    }

    public static byte[] grow(byte[] array) {
        return ArrayUtil.grow(array, 1 + array.length);
    }

    public static char[] grow(char[] array, int minSize) {
        assert (minSize >= 0) : "size must be positive (got " + minSize + "): likely integer overflow?";
        if (array.length < minSize) {
            return Arrays.copyOf(array, ArrayUtil.oversize(minSize, 2));
        }
        return array;
    }

    public static char[] grow(char[] array) {
        return ArrayUtil.grow(array, 1 + array.length);
    }

    public static int hashCode(char[] array, int start, int end) {
        int code = 0;
        for (int i2 = end - 1; i2 >= start; --i2) {
            code = code * 31 + array[i2];
        }
        return code;
    }

    public static boolean equals(byte[] left, int offsetLeft, byte[] right, int offsetRight, int length) {
        if (offsetLeft + length <= left.length && offsetRight + length <= right.length) {
            for (int i2 = 0; i2 < length; ++i2) {
                if (left[offsetLeft + i2] == right[offsetRight + i2]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static boolean equals(int[] left, int offsetLeft, int[] right, int offsetRight, int length) {
        if (offsetLeft + length <= left.length && offsetRight + length <= right.length) {
            for (int i2 = 0; i2 < length; ++i2) {
                if (left[offsetLeft + i2] == right[offsetRight + i2]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static <T> void swap(T[] arr, int i2, int j2) {
        T tmp = arr[i2];
        arr[i2] = arr[j2];
        arr[j2] = tmp;
    }

    public static <T> void introSort(T[] a2, int fromIndex, int toIndex, Comparator<? super T> comp) {
        if (toIndex - fromIndex <= 1) {
            return;
        }
        new ArrayIntroSorter<T>(a2, comp).sort(fromIndex, toIndex);
    }

    public static <T> void introSort(T[] a2, Comparator<? super T> comp) {
        ArrayUtil.introSort(a2, 0, a2.length, comp);
    }

    public static <T extends Comparable<? super T>> void introSort(T[] a2, int fromIndex, int toIndex) {
        if (toIndex - fromIndex <= 1) {
            return;
        }
        ArrayUtil.introSort(a2, fromIndex, toIndex, Comparator.naturalOrder());
    }

    public static <T extends Comparable<? super T>> void introSort(T[] a2) {
        ArrayUtil.introSort(a2, (int)0, (int)a2.length);
    }

    public static <T> void timSort(T[] a2, int fromIndex, int toIndex, Comparator<? super T> comp) {
        if (toIndex - fromIndex <= 1) {
            return;
        }
        new ArrayTimSorter<T>(a2, comp, a2.length / 64).sort(fromIndex, toIndex);
    }

    public static <T> void timSort(T[] a2, Comparator<? super T> comp) {
        ArrayUtil.timSort(a2, 0, a2.length, comp);
    }

    public static <T extends Comparable<? super T>> void timSort(T[] a2, int fromIndex, int toIndex) {
        if (toIndex - fromIndex <= 1) {
            return;
        }
        ArrayUtil.timSort(a2, fromIndex, toIndex, Comparator.naturalOrder());
    }

    public static <T extends Comparable<? super T>> void timSort(T[] a2) {
        ArrayUtil.timSort(a2, (int)0, (int)a2.length);
    }

    public static <T> void select(final T[] arr, int from, int to, int k2, final Comparator<? super T> comparator) {
        new IntroSelector(){
            T pivot;

            @Override
            protected void swap(int i2, int j2) {
                ArrayUtil.swap(arr, i2, j2);
            }

            @Override
            protected void setPivot(int i2) {
                this.pivot = arr[i2];
            }

            @Override
            protected int comparePivot(int j2) {
                return comparator.compare(this.pivot, arr[j2]);
            }
        }.select(from, to, k2);
    }
}

