/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.RandomAccess;
import org.apache.lucene.util.IntroSorter;
import org.apache.lucene.util.TimSorter;

public final class CollectionUtil {
    private CollectionUtil() {
    }

    public static <T> void introSort(List<T> list, Comparator<? super T> comp) {
        int size = list.size();
        if (size <= 1) {
            return;
        }
        new ListIntroSorter<T>(list, comp).sort(0, size);
    }

    public static <T extends Comparable<? super T>> void introSort(List<T> list) {
        int size = list.size();
        if (size <= 1) {
            return;
        }
        CollectionUtil.introSort(list, Comparator.naturalOrder());
    }

    public static <T> void timSort(List<T> list, Comparator<? super T> comp) {
        int size = list.size();
        if (size <= 1) {
            return;
        }
        new ListTimSorter<T>(list, comp, list.size() / 64).sort(0, size);
    }

    public static <T extends Comparable<? super T>> void timSort(List<T> list) {
        int size = list.size();
        if (size <= 1) {
            return;
        }
        CollectionUtil.timSort(list, Comparator.naturalOrder());
    }

    private static final class ListTimSorter<T>
    extends TimSorter {
        final List<T> list;
        final Comparator<? super T> comp;
        final T[] tmp;

        ListTimSorter(List<T> list, Comparator<? super T> comp, int maxTempSlots) {
            super(maxTempSlots);
            if (!(list instanceof RandomAccess)) {
                throw new IllegalArgumentException("CollectionUtil can only sort random access lists in-place.");
            }
            this.list = list;
            this.comp = comp;
            this.tmp = maxTempSlots > 0 ? new Object[maxTempSlots] : null;
        }

        @Override
        protected void swap(int i2, int j2) {
            Collections.swap(this.list, i2, j2);
        }

        @Override
        protected void copy(int src, int dest) {
            this.list.set(dest, this.list.get(src));
        }

        @Override
        protected void save(int i2, int len) {
            for (int j2 = 0; j2 < len; ++j2) {
                this.tmp[j2] = this.list.get(i2 + j2);
            }
        }

        @Override
        protected void restore(int i2, int j2) {
            this.list.set(j2, this.tmp[i2]);
        }

        @Override
        protected int compare(int i2, int j2) {
            return this.comp.compare(this.list.get(i2), this.list.get(j2));
        }

        @Override
        protected int compareSaved(int i2, int j2) {
            return this.comp.compare(this.tmp[i2], this.list.get(j2));
        }
    }

    private static final class ListIntroSorter<T>
    extends IntroSorter {
        T pivot;
        final List<T> list;
        final Comparator<? super T> comp;

        ListIntroSorter(List<T> list, Comparator<? super T> comp) {
            if (!(list instanceof RandomAccess)) {
                throw new IllegalArgumentException("CollectionUtil can only sort random access lists in-place.");
            }
            this.list = list;
            this.comp = comp;
        }

        @Override
        protected void setPivot(int i2) {
            this.pivot = this.list.get(i2);
        }

        @Override
        protected void swap(int i2, int j2) {
            Collections.swap(this.list, i2, j2);
        }

        @Override
        protected int compare(int i2, int j2) {
            return this.comp.compare(this.list.get(i2), this.list.get(j2));
        }

        @Override
        protected int comparePivot(int j2) {
            return this.comp.compare(this.pivot, this.list.get(j2));
        }
    }
}

