/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util;

import org.apache.lucene.util.MathUtil;
import org.apache.lucene.util.Selector;
import org.apache.lucene.util.Sorter;

public abstract class IntroSelector
extends Selector {
    @Override
    public final void select(int from, int to, int k2) {
        this.checkArgs(from, to, k2);
        int maxDepth = 2 * MathUtil.log(to - from, 2);
        this.quickSelect(from, to, k2, maxDepth);
    }

    void slowSelect(int from, int to, int k2) {
        new Sorter(){

            @Override
            protected void swap(int i2, int j2) {
                IntroSelector.this.swap(i2, j2);
            }

            @Override
            protected int compare(int i2, int j2) {
                return IntroSelector.this.compare(i2, j2);
            }

            @Override
            public void sort(int from, int to) {
                this.heapSort(from, to);
            }
        }.sort(from, to);
    }

    private void quickSelect(int from, int to, int k2, int maxDepth) {
        assert (from <= k2);
        assert (k2 < to);
        if (to - from == 1) {
            return;
        }
        if (--maxDepth < 0) {
            this.slowSelect(from, to, k2);
            return;
        }
        int mid = from + to >>> 1;
        if (this.compare(from, to - 1) > 0) {
            this.swap(from, to - 1);
        }
        if (this.compare(to - 1, mid) > 0) {
            this.swap(to - 1, mid);
            if (this.compare(from, to - 1) > 0) {
                this.swap(from, to - 1);
            }
        }
        this.setPivot(to - 1);
        int left = from + 1;
        int right = to - 2;
        while (true) {
            if (this.comparePivot(left) > 0) {
                ++left;
                continue;
            }
            while (left < right && this.comparePivot(right) <= 0) {
                --right;
            }
            if (left >= right) break;
            this.swap(left, right);
            --right;
        }
        this.swap(left, to - 1);
        if (left == k2) {
            return;
        }
        if (left < k2) {
            this.quickSelect(left + 1, to, k2, maxDepth);
        } else {
            this.quickSelect(from, left, k2, maxDepth);
        }
    }

    protected int compare(int i2, int j2) {
        this.setPivot(i2);
        return this.comparePivot(j2);
    }

    protected abstract void setPivot(int var1);

    protected abstract int comparePivot(int var1);
}

