/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util;

public class SmallFloat {
    private static final int MAX_INT4 = SmallFloat.longToInt4(Integer.MAX_VALUE);
    private static final int NUM_FREE_VALUES = 255 - MAX_INT4;

    private SmallFloat() {
    }

    public static byte floatToByte(float f2, int numMantissaBits, int zeroExp) {
        int fzero = 63 - zeroExp << numMantissaBits;
        int bits = Float.floatToRawIntBits(f2);
        int smallfloat = bits >> 24 - numMantissaBits;
        if (smallfloat <= fzero) {
            return bits <= 0 ? (byte)0 : 1;
        }
        if (smallfloat >= fzero + 256) {
            return -1;
        }
        return (byte)(smallfloat - fzero);
    }

    public static float byteToFloat(byte b2, int numMantissaBits, int zeroExp) {
        if (b2 == 0) {
            return 0.0f;
        }
        int bits = (b2 & 0xFF) << 24 - numMantissaBits;
        return Float.intBitsToFloat(bits += 63 - zeroExp << 24);
    }

    public static byte floatToByte315(float f2) {
        int bits = Float.floatToRawIntBits(f2);
        int smallfloat = bits >> 21;
        if (smallfloat <= 384) {
            return bits <= 0 ? (byte)0 : 1;
        }
        if (smallfloat >= 640) {
            return -1;
        }
        return (byte)(smallfloat - 384);
    }

    public static float byte315ToFloat(byte b2) {
        if (b2 == 0) {
            return 0.0f;
        }
        int bits = (b2 & 0xFF) << 21;
        return Float.intBitsToFloat(bits += 0x30000000);
    }

    public static int longToInt4(long i2) {
        if (i2 < 0L) {
            throw new IllegalArgumentException("Only supports positive values, got " + i2);
        }
        int numBits = 64 - Long.numberOfLeadingZeros(i2);
        if (numBits < 4) {
            return Math.toIntExact(i2);
        }
        int shift = numBits - 4;
        int encoded = Math.toIntExact(i2 >>> shift);
        encoded &= 7;
        return encoded |= shift + 1 << 3;
    }

    public static final long int4ToLong(int i2) {
        long bits = i2 & 7;
        int shift = (i2 >>> 3) - 1;
        long decoded = shift == -1 ? bits : (bits | 8L) << shift;
        return decoded;
    }

    public static byte intToByte4(int i2) {
        if (i2 < 0) {
            throw new IllegalArgumentException("Only supports positive values, got " + i2);
        }
        if (i2 < NUM_FREE_VALUES) {
            return (byte)i2;
        }
        return (byte)(NUM_FREE_VALUES + SmallFloat.longToInt4(i2 - NUM_FREE_VALUES));
    }

    public static int byte4ToInt(byte b2) {
        int i2 = Byte.toUnsignedInt(b2);
        if (i2 < NUM_FREE_VALUES) {
            return i2;
        }
        long decoded = (long)NUM_FREE_VALUES + SmallFloat.int4ToLong(i2 - NUM_FREE_VALUES);
        return Math.toIntExact(decoded);
    }
}

