/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util;

import java.io.DataInputStream;
import java.math.BigInteger;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Properties;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.IntsRef;

public abstract class StringHelper {
    public static final int GOOD_FAST_HASH_SEED;
    private static BigInteger nextId;
    private static final BigInteger mask128;
    private static final Object idLock;
    public static final int ID_LENGTH = 16;

    public static int bytesDifference(BytesRef left, BytesRef right) {
        int len = left.length < right.length ? left.length : right.length;
        byte[] bytesLeft = left.bytes;
        int offLeft = left.offset;
        byte[] bytesRight = right.bytes;
        int offRight = right.offset;
        for (int i2 = 0; i2 < len; ++i2) {
            if (bytesLeft[i2 + offLeft] == bytesRight[i2 + offRight]) continue;
            return i2;
        }
        return len;
    }

    public static int sortKeyLength(BytesRef priorTerm, BytesRef currentTerm) {
        int currentTermOffset = currentTerm.offset;
        int priorTermOffset = priorTerm.offset;
        int limit = Math.min(priorTerm.length, currentTerm.length);
        for (int i2 = 0; i2 < limit; ++i2) {
            if (priorTerm.bytes[priorTermOffset + i2] == currentTerm.bytes[currentTermOffset + i2]) continue;
            return i2 + 1;
        }
        return Math.min(1 + priorTerm.length, currentTerm.length);
    }

    private StringHelper() {
    }

    public static boolean startsWith(byte[] ref, BytesRef prefix) {
        if (ref.length < prefix.length) {
            return false;
        }
        for (int i2 = 0; i2 < prefix.length; ++i2) {
            if (ref[i2] == prefix.bytes[prefix.offset + i2]) continue;
            return false;
        }
        return true;
    }

    public static boolean startsWith(BytesRef ref, BytesRef prefix) {
        return StringHelper.sliceEquals(ref, prefix, 0);
    }

    public static boolean endsWith(BytesRef ref, BytesRef suffix) {
        return StringHelper.sliceEquals(ref, suffix, ref.length - suffix.length);
    }

    private static boolean sliceEquals(BytesRef sliceToTest, BytesRef other, int pos) {
        if (pos < 0 || sliceToTest.length - pos < other.length) {
            return false;
        }
        int i2 = sliceToTest.offset + pos;
        int j2 = other.offset;
        int k2 = other.offset + other.length;
        while (j2 < k2) {
            if (sliceToTest.bytes[i2++] == other.bytes[j2++]) continue;
            return false;
        }
        return true;
    }

    public static int murmurhash3_x86_32(byte[] data, int offset, int len, int seed) {
        int c1 = -862048943;
        int c2 = 461845907;
        int h1 = seed;
        int roundedEnd = offset + (len & 0xFFFFFFFC);
        for (int i2 = offset; i2 < roundedEnd; i2 += 4) {
            int k1 = data[i2] & 0xFF | (data[i2 + 1] & 0xFF) << 8 | (data[i2 + 2] & 0xFF) << 16 | data[i2 + 3] << 24;
            k1 *= -862048943;
            k1 = Integer.rotateLeft(k1, 15);
            h1 ^= (k1 *= 461845907);
            h1 = Integer.rotateLeft(h1, 13);
            h1 = h1 * 5 + -430675100;
        }
        int k1 = 0;
        switch (len & 3) {
            case 3: {
                k1 = (data[roundedEnd + 2] & 0xFF) << 16;
            }
            case 2: {
                k1 |= (data[roundedEnd + 1] & 0xFF) << 8;
            }
            case 1: {
                k1 |= data[roundedEnd] & 0xFF;
                k1 *= -862048943;
                k1 = Integer.rotateLeft(k1, 15);
                h1 ^= (k1 *= 461845907);
            }
        }
        h1 ^= len;
        h1 ^= h1 >>> 16;
        h1 *= -2048144789;
        h1 ^= h1 >>> 13;
        h1 *= -1028477387;
        h1 ^= h1 >>> 16;
        return h1;
    }

    public static int murmurhash3_x86_32(BytesRef bytes, int seed) {
        return StringHelper.murmurhash3_x86_32(bytes.bytes, bytes.offset, bytes.length, seed);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] randomId() {
        byte[] bits;
        Object object = idLock;
        synchronized (object) {
            bits = nextId.toByteArray();
            nextId = nextId.add(BigInteger.ONE).and(mask128);
        }
        if (bits.length > 16) {
            assert (bits.length == 17);
            assert (bits[0] == 0);
            return Arrays.copyOfRange(bits, 1, bits.length);
        }
        byte[] result = new byte[16];
        System.arraycopy(bits, 0, result, result.length - bits.length, bits.length);
        return result;
    }

    public static String idToString(byte[] id) {
        if (id == null) {
            return "(null)";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(new BigInteger(1, id).toString(36));
        if (id.length != 16) {
            sb.append(" (INVALID FORMAT)");
        }
        return sb.toString();
    }

    public static BytesRef intsRefToBytesRef(IntsRef ints) {
        byte[] bytes = new byte[ints.length];
        for (int i2 = 0; i2 < ints.length; ++i2) {
            int x2 = ints.ints[ints.offset + i2];
            if (x2 < 0 || x2 > 255) {
                throw new IllegalArgumentException("int at pos=" + i2 + " with value=" + x2 + " is out-of-bounds for byte");
            }
            bytes[i2] = (byte)x2;
        }
        return new BytesRef(bytes);
    }

    public static int compare(int count, byte[] a2, int aOffset, byte[] b2, int bOffset) {
        for (int i2 = 0; i2 < count; ++i2) {
            int cmp = (a2[aOffset + i2] & 0xFF) - (b2[bOffset + i2] & 0xFF);
            if (cmp == 0) continue;
            return cmp;
        }
        return 0;
    }

    static {
        long x1;
        long x0;
        String prop = System.getProperty("tests.seed");
        GOOD_FAST_HASH_SEED = prop != null ? prop.hashCode() : (int)System.currentTimeMillis();
        idLock = new Object();
        byte[] maskBytes128 = new byte[16];
        Arrays.fill(maskBytes128, (byte)-1);
        mask128 = new BigInteger(1, maskBytes128);
        String prop2 = System.getProperty("tests.seed");
        if (prop2 != null) {
            if (prop2.length() > 8) {
                prop2 = prop2.substring(prop2.length() - 8);
            }
            x1 = x0 = Long.parseLong(prop2, 16);
        } else {
            try (DataInputStream is = new DataInputStream(Files.newInputStream(Paths.get("/dev/urandom", new String[0]), new OpenOption[0]));){
                x0 = is.readLong();
                x1 = is.readLong();
            }
            catch (Exception unavailable) {
                x0 = System.nanoTime();
                x1 = StringHelper.class.hashCode() << 32;
                StringBuilder sb = new StringBuilder();
                try {
                    Properties p2 = System.getProperties();
                    for (String s2 : p2.stringPropertyNames()) {
                        sb.append(s2);
                        sb.append(p2.getProperty(s2));
                    }
                    x1 |= (long)sb.toString().hashCode();
                }
                catch (SecurityException notallowed) {
                    x1 |= (long)StringBuffer.class.hashCode();
                }
            }
        }
        for (int i2 = 0; i2 < 10; ++i2) {
            long s0;
            long s1 = x0;
            x0 = s0 = x1;
            s1 ^= s1 << 23;
            x1 = s1 ^ s0 ^ s1 >>> 17 ^ s0 >>> 26;
        }
        byte[] maskBytes64 = new byte[8];
        Arrays.fill(maskBytes64, (byte)-1);
        BigInteger mask64 = new BigInteger(1, maskBytes64);
        BigInteger unsignedX0 = BigInteger.valueOf(x0).and(mask64);
        BigInteger unsignedX1 = BigInteger.valueOf(x1).and(mask64);
        nextId = unsignedX0.shiftLeft(64).or(unsignedX1);
    }
}

