/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util.automaton;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.StringHelper;
import org.apache.lucene.util.automaton.Automaton;
import org.apache.lucene.util.automaton.DaciukMihovAutomatonBuilder;
import org.apache.lucene.util.automaton.Operations;

public final class Automata {
    private Automata() {
    }

    public static Automaton makeEmpty() {
        Automaton a2 = new Automaton();
        a2.finishState();
        return a2;
    }

    public static Automaton makeEmptyString() {
        Automaton a2 = new Automaton();
        a2.createState();
        a2.setAccept(0, true);
        return a2;
    }

    public static Automaton makeAnyString() {
        Automaton a2 = new Automaton();
        int s2 = a2.createState();
        a2.setAccept(s2, true);
        a2.addTransition(s2, s2, 0, 0x10FFFF);
        a2.finishState();
        return a2;
    }

    public static Automaton makeAnyBinary() {
        Automaton a2 = new Automaton();
        int s2 = a2.createState();
        a2.setAccept(s2, true);
        a2.addTransition(s2, s2, 0, 255);
        a2.finishState();
        return a2;
    }

    public static Automaton makeAnyChar() {
        return Automata.makeCharRange(0, 0x10FFFF);
    }

    public static int appendAnyChar(Automaton a2, int state) {
        int newState = a2.createState();
        a2.addTransition(state, newState, 0, 0x10FFFF);
        return newState;
    }

    public static Automaton makeChar(int c2) {
        return Automata.makeCharRange(c2, c2);
    }

    public static int appendChar(Automaton a2, int state, int c2) {
        int newState = a2.createState();
        a2.addTransition(state, newState, c2, c2);
        return newState;
    }

    public static Automaton makeCharRange(int min2, int max) {
        if (min2 > max) {
            return Automata.makeEmpty();
        }
        Automaton a2 = new Automaton();
        int s1 = a2.createState();
        int s2 = a2.createState();
        a2.setAccept(s2, true);
        a2.addTransition(s1, s2, min2, max);
        a2.finishState();
        return a2;
    }

    private static int anyOfRightLength(Automaton.Builder builder, String x2, int n2) {
        int s2 = builder.createState();
        if (x2.length() == n2) {
            builder.setAccept(s2, true);
        } else {
            builder.addTransition(s2, Automata.anyOfRightLength(builder, x2, n2 + 1), 48, 57);
        }
        return s2;
    }

    private static int atLeast(Automaton.Builder builder, String x2, int n2, Collection<Integer> initials, boolean zeros) {
        int s2 = builder.createState();
        if (x2.length() == n2) {
            builder.setAccept(s2, true);
        } else {
            if (zeros) {
                initials.add(s2);
            }
            char c2 = x2.charAt(n2);
            builder.addTransition(s2, Automata.atLeast(builder, x2, n2 + 1, initials, zeros && c2 == '0'), c2);
            if (c2 < '9') {
                builder.addTransition(s2, Automata.anyOfRightLength(builder, x2, n2 + 1), (char)(c2 + '\u0001'), 57);
            }
        }
        return s2;
    }

    private static int atMost(Automaton.Builder builder, String x2, int n2) {
        int s2 = builder.createState();
        if (x2.length() == n2) {
            builder.setAccept(s2, true);
        } else {
            char c2 = x2.charAt(n2);
            builder.addTransition(s2, Automata.atMost(builder, x2, (char)n2 + '\u0001'), c2);
            if (c2 > '0') {
                builder.addTransition(s2, Automata.anyOfRightLength(builder, x2, n2 + 1), 48, (char)(c2 - '\u0001'));
            }
        }
        return s2;
    }

    private static int between(Automaton.Builder builder, String x2, String y2, int n2, Collection<Integer> initials, boolean zeros) {
        int s2 = builder.createState();
        if (x2.length() == n2) {
            builder.setAccept(s2, true);
        } else {
            char cy;
            char cx;
            if (zeros) {
                initials.add(s2);
            }
            if ((cx = x2.charAt(n2)) == (cy = y2.charAt(n2))) {
                builder.addTransition(s2, Automata.between(builder, x2, y2, n2 + 1, initials, zeros && cx == '0'), cx);
            } else {
                builder.addTransition(s2, Automata.atLeast(builder, x2, n2 + 1, initials, zeros && cx == '0'), cx);
                builder.addTransition(s2, Automata.atMost(builder, y2, n2 + 1), cy);
                if (cx + '\u0001' < cy) {
                    builder.addTransition(s2, Automata.anyOfRightLength(builder, x2, n2 + 1), (char)(cx + '\u0001'), (char)(cy - '\u0001'));
                }
            }
        }
        return s2;
    }

    private static boolean suffixIsZeros(BytesRef br, int len) {
        for (int i2 = len; i2 < br.length; ++i2) {
            if (br.bytes[br.offset + i2] == 0) continue;
            return false;
        }
        return true;
    }

    public static Automaton makeBinaryInterval(BytesRef min2, boolean minInclusive, BytesRef max, boolean maxInclusive) {
        int i2;
        int cmp;
        if (min2 == null && !minInclusive) {
            throw new IllegalArgumentException("minInclusive must be true when min is null (open ended)");
        }
        if (max == null && !maxInclusive) {
            throw new IllegalArgumentException("maxInclusive must be true when max is null (open ended)");
        }
        if (min2 == null) {
            min2 = new BytesRef();
            minInclusive = true;
        }
        if (max != null) {
            cmp = min2.compareTo(max);
        } else {
            cmp = -1;
            if (min2.length == 0 && minInclusive) {
                return Automata.makeAnyBinary();
            }
        }
        if (cmp == 0) {
            if (!minInclusive || !maxInclusive) {
                return Automata.makeEmpty();
            }
            return Automata.makeBinary(min2);
        }
        if (cmp > 0) {
            return Automata.makeEmpty();
        }
        if (max != null && StringHelper.startsWith(max, min2) && Automata.suffixIsZeros(max, min2.length)) {
            int state;
            int i3;
            int maxLength = max.length;
            assert (maxLength > min2.length);
            if (!maxInclusive) {
                --maxLength;
            }
            if (maxLength == min2.length) {
                if (!minInclusive) {
                    return Automata.makeEmpty();
                }
                return Automata.makeBinary(min2);
            }
            Automaton a2 = new Automaton();
            int lastState = a2.createState();
            for (i3 = 0; i3 < min2.length; ++i3) {
                state = a2.createState();
                int label = min2.bytes[min2.offset + i3] & 0xFF;
                a2.addTransition(lastState, state, label);
                lastState = state;
            }
            if (minInclusive) {
                a2.setAccept(lastState, true);
            }
            for (i3 = min2.length; i3 < maxLength; ++i3) {
                state = a2.createState();
                a2.addTransition(lastState, state, 0);
                a2.setAccept(state, true);
                lastState = state;
            }
            a2.finishState();
            return a2;
        }
        Automaton a3 = new Automaton();
        int startState = a3.createState();
        int sinkState = a3.createState();
        a3.setAccept(sinkState, true);
        a3.addTransition(sinkState, sinkState, 0, 255);
        boolean equalPrefix = true;
        int lastState = startState;
        int firstMaxState = -1;
        int sharedPrefixLength = 0;
        for (i2 = 0; i2 < min2.length; ++i2) {
            int minLabel = min2.bytes[min2.offset + i2] & 0xFF;
            int maxLabel = max != null && equalPrefix && i2 < max.length ? max.bytes[max.offset + i2] & 0xFF : -1;
            int nextState = minInclusive && i2 == min2.length - 1 && (!equalPrefix || minLabel != maxLabel) ? sinkState : a3.createState();
            if (equalPrefix) {
                if (minLabel == maxLabel) {
                    a3.addTransition(lastState, nextState, minLabel);
                } else if (max == null) {
                    equalPrefix = false;
                    sharedPrefixLength = 0;
                    a3.addTransition(lastState, sinkState, minLabel + 1, 255);
                    a3.addTransition(lastState, nextState, minLabel);
                } else {
                    assert (maxLabel > minLabel);
                    a3.addTransition(lastState, nextState, minLabel);
                    if (maxLabel > minLabel + 1) {
                        a3.addTransition(lastState, sinkState, minLabel + 1, maxLabel - 1);
                    }
                    if (maxInclusive || i2 < max.length - 1) {
                        firstMaxState = a3.createState();
                        if (i2 < max.length - 1) {
                            a3.setAccept(firstMaxState, true);
                        }
                        a3.addTransition(lastState, firstMaxState, maxLabel);
                    }
                    equalPrefix = false;
                    sharedPrefixLength = i2;
                }
            } else {
                a3.addTransition(lastState, nextState, minLabel);
                if (minLabel < 255) {
                    a3.addTransition(lastState, sinkState, minLabel + 1, 255);
                }
            }
            lastState = nextState;
        }
        if (!equalPrefix && lastState != sinkState && lastState != startState) {
            a3.addTransition(lastState, sinkState, 0, 255);
        }
        if (minInclusive) {
            a3.setAccept(lastState, true);
        }
        if (max != null) {
            if (firstMaxState == -1) {
                sharedPrefixLength = min2.length;
            } else {
                lastState = firstMaxState;
                ++sharedPrefixLength;
            }
            for (i2 = sharedPrefixLength; i2 < max.length; ++i2) {
                int maxLabel = max.bytes[max.offset + i2] & 0xFF;
                if (maxLabel > 0) {
                    a3.addTransition(lastState, sinkState, 0, maxLabel - 1);
                }
                if (!maxInclusive && i2 >= max.length - 1) continue;
                int nextState = a3.createState();
                if (i2 < max.length - 1) {
                    a3.setAccept(nextState, true);
                }
                a3.addTransition(lastState, nextState, maxLabel);
                lastState = nextState;
            }
            if (maxInclusive) {
                a3.setAccept(lastState, true);
            }
        }
        a3.finishState();
        assert (a3.isDeterministic()) : a3.toDot();
        return a3;
    }

    public static Automaton makeDecimalInterval(int min2, int max, int digits) throws IllegalArgumentException {
        String x2 = Integer.toString(min2);
        String y2 = Integer.toString(max);
        if (min2 > max || digits > 0 && y2.length() > digits) {
            throw new IllegalArgumentException();
        }
        int d2 = digits > 0 ? digits : y2.length();
        StringBuilder bx = new StringBuilder();
        for (int i2 = x2.length(); i2 < d2; ++i2) {
            bx.append('0');
        }
        bx.append(x2);
        x2 = bx.toString();
        StringBuilder by = new StringBuilder();
        for (int i3 = y2.length(); i3 < d2; ++i3) {
            by.append('0');
        }
        by.append(y2);
        y2 = by.toString();
        Automaton.Builder builder = new Automaton.Builder();
        if (digits <= 0) {
            builder.createState();
        }
        ArrayList<Integer> initials = new ArrayList<Integer>();
        Automata.between(builder, x2, y2, 0, initials, digits <= 0);
        Automaton a1 = builder.finish();
        if (digits <= 0) {
            a1.addTransition(0, 0, 48);
            Iterator iterator = initials.iterator();
            while (iterator.hasNext()) {
                int p2 = (Integer)iterator.next();
                a1.addEpsilon(0, p2);
            }
            a1.finishState();
        }
        return a1;
    }

    public static Automaton makeString(String s2) {
        Automaton a2 = new Automaton();
        int lastState = a2.createState();
        int cp = 0;
        for (int i2 = 0; i2 < s2.length(); i2 += Character.charCount(cp)) {
            int state = a2.createState();
            cp = s2.codePointAt(i2);
            a2.addTransition(lastState, state, cp);
            lastState = state;
        }
        a2.setAccept(lastState, true);
        a2.finishState();
        assert (a2.isDeterministic());
        assert (!Operations.hasDeadStates(a2));
        return a2;
    }

    public static Automaton makeBinary(BytesRef term) {
        Automaton a2 = new Automaton();
        int lastState = a2.createState();
        for (int i2 = 0; i2 < term.length; ++i2) {
            int state = a2.createState();
            int label = term.bytes[term.offset + i2] & 0xFF;
            a2.addTransition(lastState, state, label);
            lastState = state;
        }
        a2.setAccept(lastState, true);
        a2.finishState();
        assert (a2.isDeterministic());
        assert (!Operations.hasDeadStates(a2));
        return a2;
    }

    public static Automaton makeString(int[] word, int offset, int length) {
        Automaton a2 = new Automaton();
        a2.createState();
        int s2 = 0;
        for (int i2 = offset; i2 < offset + length; ++i2) {
            int s22 = a2.createState();
            a2.addTransition(s2, s22, word[i2]);
            s2 = s22;
        }
        a2.setAccept(s2, true);
        a2.finishState();
        return a2;
    }

    public static Automaton makeStringUnion(Collection<BytesRef> utf8Strings) {
        if (utf8Strings.isEmpty()) {
            return Automata.makeEmpty();
        }
        return DaciukMihovAutomatonBuilder.build(utf8Strings);
    }
}

