/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util.automaton;

import org.apache.lucene.util.automaton.Automaton;
import org.apache.lucene.util.automaton.RunAutomaton;
import org.apache.lucene.util.automaton.UTF32ToUTF8;

public class ByteRunAutomaton
extends RunAutomaton {
    public ByteRunAutomaton(Automaton a2) {
        this(a2, false, 10000);
    }

    public ByteRunAutomaton(Automaton a2, boolean isBinary, int maxDeterminizedStates) {
        super(isBinary ? a2 : new UTF32ToUTF8().convert(a2), 256, maxDeterminizedStates);
    }

    public boolean run(byte[] s2, int offset, int length) {
        int p2 = 0;
        int l2 = offset + length;
        for (int i2 = offset; i2 < l2; ++i2) {
            if ((p2 = this.step(p2, s2[i2] & 0xFF)) != -1) continue;
            return false;
        }
        return this.accept[p2];
    }
}

