/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util.automaton;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.apache.lucene.util.IntsRef;
import org.apache.lucene.util.IntsRefBuilder;
import org.apache.lucene.util.RamUsageEstimator;
import org.apache.lucene.util.automaton.Automata;
import org.apache.lucene.util.automaton.Automaton;
import org.apache.lucene.util.automaton.SortedIntSet;
import org.apache.lucene.util.automaton.StatePair;
import org.apache.lucene.util.automaton.TooComplexToDeterminizeException;
import org.apache.lucene.util.automaton.Transition;

public final class Operations {
    public static final int DEFAULT_MAX_DETERMINIZED_STATES = 10000;
    public static final int MAX_RECURSION_LEVEL = 1000;

    private Operations() {
    }

    public static Automaton concatenate(Automaton a1, Automaton a2) {
        return Operations.concatenate(Arrays.asList(a1, a2));
    }

    public static Automaton concatenate(List<Automaton> l2) {
        Automaton result = new Automaton();
        for (Automaton a2 : l2) {
            if (a2.getNumStates() == 0) {
                result.finishState();
                return result;
            }
            int numStates = a2.getNumStates();
            for (int s2 = 0; s2 < numStates; ++s2) {
                result.createState();
            }
        }
        int stateOffset = 0;
        Transition t2 = new Transition();
        for (int i2 = 0; i2 < l2.size(); ++i2) {
            Automaton a3 = l2.get(i2);
            int numStates = a3.getNumStates();
            Automaton nextA = i2 == l2.size() - 1 ? null : l2.get(i2 + 1);
            block3: for (int s3 = 0; s3 < numStates; ++s3) {
                int numTransitions = a3.initTransition(s3, t2);
                for (int j2 = 0; j2 < numTransitions; ++j2) {
                    a3.getNextTransition(t2);
                    result.addTransition(stateOffset + s3, stateOffset + t2.dest, t2.min, t2.max);
                }
                if (!a3.isAccept(s3)) continue;
                Automaton followA = nextA;
                int followOffset = stateOffset;
                int upto = i2 + 1;
                while (followA != null) {
                    numTransitions = followA.initTransition(0, t2);
                    for (int j3 = 0; j3 < numTransitions; ++j3) {
                        followA.getNextTransition(t2);
                        result.addTransition(stateOffset + s3, followOffset + numStates + t2.dest, t2.min, t2.max);
                    }
                    if (!followA.isAccept(0)) continue block3;
                    followOffset += followA.getNumStates();
                    followA = upto == l2.size() - 1 ? null : l2.get(upto + 1);
                    ++upto;
                }
                result.setAccept(stateOffset + s3, true);
            }
            stateOffset += numStates;
        }
        if (result.getNumStates() == 0) {
            result.createState();
        }
        result.finishState();
        return result;
    }

    public static Automaton optional(Automaton a2) {
        Automaton result = new Automaton();
        result.createState();
        result.setAccept(0, true);
        if (a2.getNumStates() > 0) {
            result.copy(a2);
            result.addEpsilon(0, 1);
        }
        result.finishState();
        return result;
    }

    public static Automaton repeat(Automaton a2) {
        if (a2.getNumStates() == 0) {
            return a2;
        }
        Automaton.Builder builder = new Automaton.Builder();
        builder.createState();
        builder.setAccept(0, true);
        builder.copy(a2);
        Transition t2 = new Transition();
        int count = a2.initTransition(0, t2);
        for (int i2 = 0; i2 < count; ++i2) {
            a2.getNextTransition(t2);
            builder.addTransition(0, t2.dest + 1, t2.min, t2.max);
        }
        int numStates = a2.getNumStates();
        for (int s2 = 0; s2 < numStates; ++s2) {
            if (!a2.isAccept(s2)) continue;
            count = a2.initTransition(0, t2);
            for (int i3 = 0; i3 < count; ++i3) {
                a2.getNextTransition(t2);
                builder.addTransition(s2 + 1, t2.dest + 1, t2.min, t2.max);
            }
        }
        return builder.finish();
    }

    public static Automaton repeat(Automaton a2, int count) {
        if (count == 0) {
            return Operations.repeat(a2);
        }
        ArrayList<Automaton> as2 = new ArrayList<Automaton>();
        while (count-- > 0) {
            as2.add(a2);
        }
        as2.add(Operations.repeat(a2));
        return Operations.concatenate(as2);
    }

    public static Automaton repeat(Automaton a2, int min2, int max) {
        Automaton b2;
        if (min2 > max) {
            return Automata.makeEmpty();
        }
        if (min2 == 0) {
            b2 = Automata.makeEmptyString();
        } else if (min2 == 1) {
            b2 = new Automaton();
            b2.copy(a2);
        } else {
            ArrayList<Automaton> as2 = new ArrayList<Automaton>();
            for (int i2 = 0; i2 < min2; ++i2) {
                as2.add(a2);
            }
            b2 = Operations.concatenate(as2);
        }
        Set<Integer> prevAcceptStates = Operations.toSet(b2, 0);
        Automaton.Builder builder = new Automaton.Builder();
        builder.copy(b2);
        for (int i3 = min2; i3 < max; ++i3) {
            int numStates = builder.getNumStates();
            builder.copy(a2);
            for (int s2 : prevAcceptStates) {
                builder.addEpsilon(s2, numStates);
            }
            prevAcceptStates = Operations.toSet(a2, numStates);
        }
        return builder.finish();
    }

    private static Set<Integer> toSet(Automaton a2, int offset) {
        int numStates = a2.getNumStates();
        BitSet isAccept = a2.getAcceptStates();
        HashSet<Integer> result = new HashSet<Integer>();
        for (int upto = 0; upto < numStates && (upto = isAccept.nextSetBit(upto)) != -1; ++upto) {
            result.add(offset + upto);
        }
        return result;
    }

    public static Automaton complement(Automaton a2, int maxDeterminizedStates) {
        a2 = Operations.totalize(Operations.determinize(a2, maxDeterminizedStates));
        int numStates = a2.getNumStates();
        for (int p2 = 0; p2 < numStates; ++p2) {
            a2.setAccept(p2, !a2.isAccept(p2));
        }
        return Operations.removeDeadStates(a2);
    }

    public static Automaton minus(Automaton a1, Automaton a2, int maxDeterminizedStates) {
        if (Operations.isEmpty(a1) || a1 == a2) {
            return Automata.makeEmpty();
        }
        if (Operations.isEmpty(a2)) {
            return a1;
        }
        return Operations.intersection(a1, Operations.complement(a2, maxDeterminizedStates));
    }

    public static Automaton intersection(Automaton a1, Automaton a2) {
        if (a1 == a2) {
            return a1;
        }
        if (a1.getNumStates() == 0) {
            return a1;
        }
        if (a2.getNumStates() == 0) {
            return a2;
        }
        Transition[][] transitions1 = a1.getSortedTransitions();
        Transition[][] transitions2 = a2.getSortedTransitions();
        Automaton c2 = new Automaton();
        c2.createState();
        ArrayDeque<StatePair> worklist = new ArrayDeque<StatePair>();
        HashMap<StatePair, StatePair> newstates = new HashMap<StatePair, StatePair>();
        StatePair p2 = new StatePair(0, 0, 0);
        worklist.add(p2);
        newstates.put(p2, p2);
        while (worklist.size() > 0) {
            p2 = (StatePair)worklist.removeFirst();
            c2.setAccept(p2.s, a1.isAccept(p2.s1) && a2.isAccept(p2.s2));
            Transition[] t1 = transitions1[p2.s1];
            Transition[] t2 = transitions2[p2.s2];
            int b2 = 0;
            for (int n1 = 0; n1 < t1.length; ++n1) {
                while (b2 < t2.length && t2[b2].max < t1[n1].min) {
                    ++b2;
                }
                for (int n2 = b2; n2 < t2.length && t1[n1].max >= t2[n2].min; ++n2) {
                    if (t2[n2].max < t1[n1].min) continue;
                    StatePair q2 = new StatePair(t1[n1].dest, t2[n2].dest);
                    StatePair r2 = (StatePair)newstates.get(q2);
                    if (r2 == null) {
                        q2.s = c2.createState();
                        worklist.add(q2);
                        newstates.put(q2, q2);
                        r2 = q2;
                    }
                    int min2 = t1[n1].min > t2[n2].min ? t1[n1].min : t2[n2].min;
                    int max = t1[n1].max < t2[n2].max ? t1[n1].max : t2[n2].max;
                    c2.addTransition(p2.s, r2.s, min2, max);
                }
            }
        }
        c2.finishState();
        return Operations.removeDeadStates(c2);
    }

    public static boolean sameLanguage(Automaton a1, Automaton a2) {
        if (a1 == a2) {
            return true;
        }
        return Operations.subsetOf(a2, a1) && Operations.subsetOf(a1, a2);
    }

    public static boolean hasDeadStates(Automaton a2) {
        BitSet liveStates = Operations.getLiveStates(a2);
        int numLive = liveStates.cardinality();
        int numStates = a2.getNumStates();
        assert (numLive <= numStates) : "numLive=" + numLive + " numStates=" + numStates + " " + liveStates;
        return numLive < numStates;
    }

    public static boolean hasDeadStatesFromInitial(Automaton a2) {
        BitSet reachableFromInitial = Operations.getLiveStatesFromInitial(a2);
        BitSet reachableFromAccept = Operations.getLiveStatesToAccept(a2);
        reachableFromInitial.andNot(reachableFromAccept);
        return !reachableFromInitial.isEmpty();
    }

    public static boolean hasDeadStatesToAccept(Automaton a2) {
        BitSet reachableFromInitial = Operations.getLiveStatesFromInitial(a2);
        BitSet reachableFromAccept = Operations.getLiveStatesToAccept(a2);
        reachableFromAccept.andNot(reachableFromInitial);
        return !reachableFromAccept.isEmpty();
    }

    public static boolean subsetOf(Automaton a1, Automaton a2) {
        if (!a1.isDeterministic()) {
            throw new IllegalArgumentException("a1 must be deterministic");
        }
        if (!a2.isDeterministic()) {
            throw new IllegalArgumentException("a2 must be deterministic");
        }
        assert (!Operations.hasDeadStatesFromInitial(a1));
        assert (!Operations.hasDeadStatesFromInitial(a2));
        if (a1.getNumStates() == 0) {
            return true;
        }
        if (a2.getNumStates() == 0) {
            return Operations.isEmpty(a1);
        }
        Transition[][] transitions1 = a1.getSortedTransitions();
        Transition[][] transitions2 = a2.getSortedTransitions();
        ArrayDeque<StatePair> worklist = new ArrayDeque<StatePair>();
        HashSet<StatePair> visited = new HashSet<StatePair>();
        StatePair p2 = new StatePair(0, 0);
        worklist.add(p2);
        visited.add(p2);
        while (worklist.size() > 0) {
            p2 = (StatePair)worklist.removeFirst();
            if (a1.isAccept(p2.s1) && !a2.isAccept(p2.s2)) {
                return false;
            }
            Transition[] t1 = transitions1[p2.s1];
            Transition[] t2 = transitions2[p2.s2];
            int b2 = 0;
            for (int n1 = 0; n1 < t1.length; ++n1) {
                while (b2 < t2.length && t2[b2].max < t1[n1].min) {
                    ++b2;
                }
                int min1 = t1[n1].min;
                int max1 = t1[n1].max;
                for (int n2 = b2; n2 < t2.length && t1[n1].max >= t2[n2].min; ++n2) {
                    if (t2[n2].min > min1) {
                        return false;
                    }
                    if (t2[n2].max < 0x10FFFF) {
                        min1 = t2[n2].max + 1;
                    } else {
                        min1 = 0x10FFFF;
                        max1 = 0;
                    }
                    StatePair q2 = new StatePair(t1[n1].dest, t2[n2].dest);
                    if (visited.contains(q2)) continue;
                    worklist.add(q2);
                    visited.add(q2);
                }
                if (min1 > max1) continue;
                return false;
            }
        }
        return true;
    }

    public static Automaton union(Automaton a1, Automaton a2) {
        return Operations.union(Arrays.asList(a1, a2));
    }

    public static Automaton union(Collection<Automaton> l2) {
        Automaton result = new Automaton();
        result.createState();
        for (Automaton a2 : l2) {
            result.copy(a2);
        }
        int stateOffset = 1;
        for (Automaton a3 : l2) {
            if (a3.getNumStates() == 0) continue;
            result.addEpsilon(0, stateOffset);
            stateOffset += a3.getNumStates();
        }
        result.finishState();
        return Operations.removeDeadStates(result);
    }

    public static Automaton determinize(Automaton a2, int maxDeterminizedStates) {
        if (a2.isDeterministic()) {
            return a2;
        }
        if (a2.getNumStates() <= 1) {
            return a2;
        }
        Automaton.Builder b2 = new Automaton.Builder();
        SortedIntSet.FrozenIntSet initialset = new SortedIntSet.FrozenIntSet(0, 0);
        b2.createState();
        ArrayDeque<SortedIntSet.FrozenIntSet> worklist = new ArrayDeque<SortedIntSet.FrozenIntSet>();
        HashMap<SortedIntSet.FrozenIntSet, Integer> newstate = new HashMap<SortedIntSet.FrozenIntSet, Integer>();
        worklist.add(initialset);
        b2.setAccept(0, a2.isAccept(0));
        newstate.put(initialset, 0);
        PointTransitionSet points = new PointTransitionSet();
        SortedIntSet statesSet = new SortedIntSet(5);
        Transition t2 = new Transition();
        while (worklist.size() > 0) {
            SortedIntSet.FrozenIntSet s2 = (SortedIntSet.FrozenIntSet)worklist.removeFirst();
            for (int i2 = 0; i2 < s2.values.length; ++i2) {
                int s0 = s2.values[i2];
                int numTransitions = a2.getNumTransitions(s0);
                a2.initTransition(s0, t2);
                for (int j2 = 0; j2 < numTransitions; ++j2) {
                    a2.getNextTransition(t2);
                    points.add(t2);
                }
            }
            if (points.count == 0) continue;
            points.sort();
            int lastPoint = -1;
            int accCount = 0;
            int r2 = s2.state;
            for (int i3 = 0; i3 < points.count; ++i3) {
                int dest;
                int j3;
                int point = points.points[i3].point;
                if (statesSet.upto > 0) {
                    assert (lastPoint != -1);
                    statesSet.computeHash();
                    Integer q2 = (Integer)newstate.get(statesSet);
                    if (q2 == null) {
                        q2 = b2.createState();
                        if (q2 >= maxDeterminizedStates) {
                            throw new TooComplexToDeterminizeException(a2, maxDeterminizedStates);
                        }
                        SortedIntSet.FrozenIntSet p2 = statesSet.freeze(q2);
                        worklist.add(p2);
                        b2.setAccept(q2, accCount > 0);
                        newstate.put(p2, q2);
                    } else assert (accCount > 0 == b2.isAccept(q2)) : "accCount=" + accCount + " vs existing accept=" + b2.isAccept(q2) + " states=" + statesSet;
                    b2.addTransition(r2, q2, lastPoint, point - 1);
                }
                int[] transitions = points.points[i3].ends.transitions;
                int limit = points.points[i3].ends.next;
                for (j3 = 0; j3 < limit; j3 += 3) {
                    dest = transitions[j3];
                    statesSet.decr(dest);
                    accCount -= a2.isAccept(dest) ? 1 : 0;
                }
                points.points[i3].ends.next = 0;
                transitions = points.points[i3].starts.transitions;
                limit = points.points[i3].starts.next;
                for (j3 = 0; j3 < limit; j3 += 3) {
                    dest = transitions[j3];
                    statesSet.incr(dest);
                    accCount += a2.isAccept(dest) ? 1 : 0;
                }
                lastPoint = point;
                points.points[i3].starts.next = 0;
            }
            points.reset();
            assert (statesSet.upto == 0) : "upto=" + statesSet.upto;
        }
        Automaton result = b2.finish();
        assert (result.isDeterministic());
        return result;
    }

    public static boolean isEmpty(Automaton a2) {
        if (a2.getNumStates() == 0) {
            return true;
        }
        if (!a2.isAccept(0) && a2.getNumTransitions(0) == 0) {
            return true;
        }
        if (a2.isAccept(0)) {
            return false;
        }
        ArrayDeque<Integer> workList = new ArrayDeque<Integer>();
        BitSet seen = new BitSet(a2.getNumStates());
        workList.add(0);
        seen.set(0);
        Transition t2 = new Transition();
        while (!workList.isEmpty()) {
            int state = (Integer)workList.removeFirst();
            if (a2.isAccept(state)) {
                return false;
            }
            int count = a2.initTransition(state, t2);
            for (int i2 = 0; i2 < count; ++i2) {
                a2.getNextTransition(t2);
                if (seen.get(t2.dest)) continue;
                workList.add(t2.dest);
                seen.set(t2.dest);
            }
        }
        return true;
    }

    public static boolean isTotal(Automaton a2) {
        return Operations.isTotal(a2, 0, 0x10FFFF);
    }

    public static boolean isTotal(Automaton a2, int minAlphabet, int maxAlphabet) {
        if (a2.isAccept(0) && a2.getNumTransitions(0) == 1) {
            Transition t2 = new Transition();
            a2.getTransition(0, 0, t2);
            return t2.dest == 0 && t2.min == minAlphabet && t2.max == maxAlphabet;
        }
        return false;
    }

    public static boolean run(Automaton a2, String s2) {
        assert (a2.isDeterministic());
        int state = 0;
        int cp = 0;
        for (int i2 = 0; i2 < s2.length(); i2 += Character.charCount(cp)) {
            cp = s2.codePointAt(i2);
            int nextState = a2.step(state, cp);
            if (nextState == -1) {
                return false;
            }
            state = nextState;
        }
        return a2.isAccept(state);
    }

    public static boolean run(Automaton a2, IntsRef s2) {
        assert (a2.isDeterministic());
        int state = 0;
        for (int i2 = 0; i2 < s2.length; ++i2) {
            int nextState = a2.step(state, s2.ints[s2.offset + i2]);
            if (nextState == -1) {
                return false;
            }
            state = nextState;
        }
        return a2.isAccept(state);
    }

    private static BitSet getLiveStates(Automaton a2) {
        BitSet live = Operations.getLiveStatesFromInitial(a2);
        live.and(Operations.getLiveStatesToAccept(a2));
        return live;
    }

    private static BitSet getLiveStatesFromInitial(Automaton a2) {
        int numStates = a2.getNumStates();
        BitSet live = new BitSet(numStates);
        if (numStates == 0) {
            return live;
        }
        ArrayDeque<Integer> workList = new ArrayDeque<Integer>();
        live.set(0);
        workList.add(0);
        Transition t2 = new Transition();
        while (!workList.isEmpty()) {
            int s2 = (Integer)workList.removeFirst();
            int count = a2.initTransition(s2, t2);
            for (int i2 = 0; i2 < count; ++i2) {
                a2.getNextTransition(t2);
                if (live.get(t2.dest)) continue;
                live.set(t2.dest);
                workList.add(t2.dest);
            }
        }
        return live;
    }

    private static BitSet getLiveStatesToAccept(Automaton a2) {
        int s2;
        int s3;
        Automaton.Builder builder = new Automaton.Builder();
        Transition t2 = new Transition();
        int numStates = a2.getNumStates();
        for (s3 = 0; s3 < numStates; ++s3) {
            builder.createState();
        }
        for (s3 = 0; s3 < numStates; ++s3) {
            int count = a2.initTransition(s3, t2);
            for (int i2 = 0; i2 < count; ++i2) {
                a2.getNextTransition(t2);
                builder.addTransition(t2.dest, s3, t2.min, t2.max);
            }
        }
        Automaton a22 = builder.finish();
        ArrayDeque<Integer> workList = new ArrayDeque<Integer>();
        BitSet live = new BitSet(numStates);
        BitSet acceptBits = a2.getAcceptStates();
        for (s2 = 0; s2 < numStates && (s2 = acceptBits.nextSetBit(s2)) != -1; ++s2) {
            live.set(s2);
            workList.add(s2);
        }
        while (!workList.isEmpty()) {
            s2 = (Integer)workList.removeFirst();
            int count = a22.initTransition(s2, t2);
            for (int i3 = 0; i3 < count; ++i3) {
                a22.getNextTransition(t2);
                if (live.get(t2.dest)) continue;
                live.set(t2.dest);
                workList.add(t2.dest);
            }
        }
        return live;
    }

    public static Automaton removeDeadStates(Automaton a2) {
        int numStates = a2.getNumStates();
        BitSet liveSet = Operations.getLiveStates(a2);
        int[] map = new int[numStates];
        Automaton result = new Automaton();
        for (int i2 = 0; i2 < numStates; ++i2) {
            if (!liveSet.get(i2)) continue;
            map[i2] = result.createState();
            result.setAccept(map[i2], a2.isAccept(i2));
        }
        Transition t2 = new Transition();
        for (int i3 = 0; i3 < numStates; ++i3) {
            if (!liveSet.get(i3)) continue;
            int numTransitions = a2.initTransition(i3, t2);
            for (int j2 = 0; j2 < numTransitions; ++j2) {
                a2.getNextTransition(t2);
                if (!liveSet.get(t2.dest)) continue;
                result.addTransition(map[i3], map[t2.dest], t2.min, t2.max);
            }
        }
        result.finishState();
        assert (!Operations.hasDeadStates(result));
        return result;
    }

    public static boolean isFinite(Automaton a2) {
        if (a2.getNumStates() == 0) {
            return true;
        }
        return Operations.isFinite(new Transition(), a2, 0, new BitSet(a2.getNumStates()), new BitSet(a2.getNumStates()), 0);
    }

    private static boolean isFinite(Transition scratch, Automaton a2, int state, BitSet path, BitSet visited, int level) {
        if (level > 1000) {
            throw new IllegalArgumentException("input automaton is too large: " + level);
        }
        path.set(state);
        int numTransitions = a2.initTransition(state, scratch);
        for (int t2 = 0; t2 < numTransitions; ++t2) {
            a2.getTransition(state, t2, scratch);
            if (!path.get(scratch.dest) && (visited.get(scratch.dest) || Operations.isFinite(scratch, a2, scratch.dest, path, visited, level + 1))) continue;
            return false;
        }
        path.clear(state);
        visited.set(state);
        return true;
    }

    public static String getCommonPrefix(Automaton a2) {
        boolean done;
        if (!a2.isDeterministic()) {
            throw new IllegalArgumentException("input automaton must be deterministic");
        }
        StringBuilder b2 = new StringBuilder();
        HashSet<Integer> visited = new HashSet<Integer>();
        int s2 = 0;
        Transition t2 = new Transition();
        do {
            done = true;
            visited.add(s2);
            if (a2.isAccept(s2) || a2.getNumTransitions(s2) != 1) continue;
            a2.getTransition(s2, 0, t2);
            if (t2.min != t2.max || visited.contains(t2.dest)) continue;
            b2.appendCodePoint(t2.min);
            s2 = t2.dest;
            done = false;
        } while (!done);
        return b2.toString();
    }

    public static BytesRef getCommonPrefixBytesRef(Automaton a2) {
        boolean done;
        BytesRefBuilder builder = new BytesRefBuilder();
        HashSet<Integer> visited = new HashSet<Integer>();
        int s2 = 0;
        Transition t2 = new Transition();
        do {
            done = true;
            visited.add(s2);
            if (a2.isAccept(s2) || a2.getNumTransitions(s2) != 1) continue;
            a2.getTransition(s2, 0, t2);
            if (t2.min != t2.max || visited.contains(t2.dest)) continue;
            builder.append((byte)t2.min);
            s2 = t2.dest;
            done = false;
        } while (!done);
        return builder.get();
    }

    public static IntsRef getSingleton(Automaton a2) {
        block5: {
            if (!a2.isDeterministic()) {
                throw new IllegalArgumentException("input automaton must be deterministic");
            }
            IntsRefBuilder builder = new IntsRefBuilder();
            HashSet<Integer> visited = new HashSet<Integer>();
            int s2 = 0;
            Transition t2 = new Transition();
            while (true) {
                visited.add(s2);
                if (a2.isAccept(s2)) break;
                if (a2.getNumTransitions(s2) == 1) {
                    a2.getTransition(s2, 0, t2);
                    if (t2.min == t2.max && !visited.contains(t2.dest)) {
                        builder.append(t2.min);
                        s2 = t2.dest;
                        continue;
                    }
                }
                break block5;
                break;
            }
            if (a2.getNumTransitions(s2) == 0) {
                return builder.get();
            }
        }
        return null;
    }

    public static BytesRef getCommonSuffixBytesRef(Automaton a2, int maxDeterminizedStates) {
        Automaton r2 = Operations.determinize(Operations.reverse(a2), maxDeterminizedStates);
        BytesRef ref = Operations.getCommonPrefixBytesRef(r2);
        Operations.reverseBytes(ref);
        return ref;
    }

    private static void reverseBytes(BytesRef ref) {
        if (ref.length <= 1) {
            return;
        }
        int num = ref.length >> 1;
        for (int i2 = ref.offset; i2 < ref.offset + num; ++i2) {
            byte b2 = ref.bytes[i2];
            ref.bytes[i2] = ref.bytes[ref.offset * 2 + ref.length - i2 - 1];
            ref.bytes[ref.offset * 2 + ref.length - i2 - 1] = b2;
        }
    }

    public static Automaton reverse(Automaton a2) {
        return Operations.reverse(a2, null);
    }

    static Automaton reverse(Automaton a2, Set<Integer> initialStates) {
        if (Operations.isEmpty(a2)) {
            return new Automaton();
        }
        int numStates = a2.getNumStates();
        Automaton.Builder builder = new Automaton.Builder();
        builder.createState();
        for (int s2 = 0; s2 < numStates; ++s2) {
            builder.createState();
        }
        builder.setAccept(1, true);
        Transition t2 = new Transition();
        for (int s3 = 0; s3 < numStates; ++s3) {
            int numTransitions = a2.getNumTransitions(s3);
            a2.initTransition(s3, t2);
            for (int i2 = 0; i2 < numTransitions; ++i2) {
                a2.getNextTransition(t2);
                builder.addTransition(t2.dest + 1, s3 + 1, t2.min, t2.max);
            }
        }
        Automaton result = builder.finish();
        BitSet acceptStates = a2.getAcceptStates();
        for (int s4 = 0; s4 < numStates && (s4 = acceptStates.nextSetBit(s4)) != -1; ++s4) {
            result.addEpsilon(0, s4 + 1);
            if (initialStates == null) continue;
            initialStates.add(s4 + 1);
        }
        result.finishState();
        return result;
    }

    static Automaton totalize(Automaton a2) {
        Automaton result = new Automaton();
        int numStates = a2.getNumStates();
        for (int i2 = 0; i2 < numStates; ++i2) {
            result.createState();
            result.setAccept(i2, a2.isAccept(i2));
        }
        int deadState = result.createState();
        result.addTransition(deadState, deadState, 0, 0x10FFFF);
        Transition t2 = new Transition();
        for (int i3 = 0; i3 < numStates; ++i3) {
            int maxi = 0;
            int count = a2.initTransition(i3, t2);
            for (int j2 = 0; j2 < count; ++j2) {
                a2.getNextTransition(t2);
                result.addTransition(i3, t2.dest, t2.min, t2.max);
                if (t2.min > maxi) {
                    result.addTransition(i3, deadState, maxi, t2.min - 1);
                }
                if (t2.max + 1 <= maxi) continue;
                maxi = t2.max + 1;
            }
            if (maxi > 0x10FFFF) continue;
            result.addTransition(i3, deadState, maxi, 0x10FFFF);
        }
        result.finishState();
        return result;
    }

    public static int[] topoSortStates(Automaton a2) {
        int[] states;
        if (a2.getNumStates() == 0) {
            return new int[0];
        }
        int numStates = a2.getNumStates();
        BitSet visited = new BitSet(numStates);
        int upto = Operations.topoSortStatesRecurse(a2, visited, states = new int[numStates], 0, 0, 0);
        if (upto < states.length) {
            int[] newStates = new int[upto];
            System.arraycopy(states, 0, newStates, 0, upto);
            states = newStates;
        }
        for (int i2 = 0; i2 < states.length / 2; ++i2) {
            int s2 = states[i2];
            states[i2] = states[states.length - 1 - i2];
            states[states.length - 1 - i2] = s2;
        }
        return states;
    }

    private static int topoSortStatesRecurse(Automaton a2, BitSet visited, int[] states, int upto, int state, int level) {
        if (level > 1000) {
            throw new IllegalArgumentException("input automaton is too large: " + level);
        }
        Transition t2 = new Transition();
        int count = a2.initTransition(state, t2);
        for (int i2 = 0; i2 < count; ++i2) {
            a2.getNextTransition(t2);
            if (visited.get(t2.dest)) continue;
            visited.set(t2.dest);
            upto = Operations.topoSortStatesRecurse(a2, visited, states, upto, t2.dest, level + 1);
        }
        states[upto] = state;
        return ++upto;
    }

    private static final class PointTransitionSet {
        int count;
        PointTransitions[] points = new PointTransitions[5];
        private static final int HASHMAP_CUTOVER = 30;
        private final HashMap<Integer, PointTransitions> map = new HashMap();
        private boolean useHash = false;

        private PointTransitionSet() {
        }

        private PointTransitions next(int point) {
            PointTransitions points0;
            if (this.count == this.points.length) {
                PointTransitions[] newArray = new PointTransitions[ArrayUtil.oversize(1 + this.count, RamUsageEstimator.NUM_BYTES_OBJECT_REF)];
                System.arraycopy(this.points, 0, newArray, 0, this.count);
                this.points = newArray;
            }
            if ((points0 = this.points[this.count]) == null) {
                points0 = this.points[this.count] = new PointTransitions();
            }
            points0.reset(point);
            ++this.count;
            return points0;
        }

        private PointTransitions find(int point) {
            if (this.useHash) {
                Integer pi = point;
                PointTransitions p2 = this.map.get(pi);
                if (p2 == null) {
                    p2 = this.next(point);
                    this.map.put(pi, p2);
                }
                return p2;
            }
            for (int i2 = 0; i2 < this.count; ++i2) {
                if (this.points[i2].point != point) continue;
                return this.points[i2];
            }
            PointTransitions p3 = this.next(point);
            if (this.count == 30) {
                assert (this.map.size() == 0);
                for (int i3 = 0; i3 < this.count; ++i3) {
                    this.map.put(this.points[i3].point, this.points[i3]);
                }
                this.useHash = true;
            }
            return p3;
        }

        public void reset() {
            if (this.useHash) {
                this.map.clear();
                this.useHash = false;
            }
            this.count = 0;
        }

        public void sort() {
            if (this.count > 1) {
                ArrayUtil.timSort((Comparable[])this.points, (int)0, (int)this.count);
            }
        }

        public void add(Transition t2) {
            this.find((int)t2.min).starts.add(t2);
            this.find((int)(1 + t2.max)).ends.add(t2);
        }

        public String toString() {
            StringBuilder s2 = new StringBuilder();
            for (int i2 = 0; i2 < this.count; ++i2) {
                if (i2 > 0) {
                    s2.append(' ');
                }
                s2.append(this.points[i2].point).append(':').append(this.points[i2].starts.next / 3).append(',').append(this.points[i2].ends.next / 3);
            }
            return s2.toString();
        }
    }

    private static final class PointTransitions
    implements Comparable<PointTransitions> {
        int point;
        final TransitionList ends = new TransitionList();
        final TransitionList starts = new TransitionList();

        private PointTransitions() {
        }

        @Override
        public int compareTo(PointTransitions other) {
            return this.point - other.point;
        }

        public void reset(int point) {
            this.point = point;
            this.ends.next = 0;
            this.starts.next = 0;
        }

        public boolean equals(Object other) {
            return ((PointTransitions)other).point == this.point;
        }

        public int hashCode() {
            return this.point;
        }
    }

    private static final class TransitionList {
        int[] transitions = new int[3];
        int next;

        private TransitionList() {
        }

        public void add(Transition t2) {
            if (this.transitions.length < this.next + 3) {
                this.transitions = ArrayUtil.grow(this.transitions, this.next + 3);
            }
            this.transitions[this.next] = t2.dest;
            this.transitions[this.next + 1] = t2.min;
            this.transitions[this.next + 2] = t2.max;
            this.next += 3;
        }
    }
}

