/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util.automaton;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.util.automaton.Automata;
import org.apache.lucene.util.automaton.Automaton;
import org.apache.lucene.util.automaton.AutomatonProvider;
import org.apache.lucene.util.automaton.MinimizationOperations;
import org.apache.lucene.util.automaton.Operations;
import org.apache.lucene.util.automaton.TooComplexToDeterminizeException;

public class RegExp {
    public static final int INTERSECTION = 1;
    public static final int COMPLEMENT = 2;
    public static final int EMPTY = 4;
    public static final int ANYSTRING = 8;
    public static final int AUTOMATON = 16;
    public static final int INTERVAL = 32;
    public static final int ALL = 65535;
    public static final int NONE = 0;
    private final String originalString;
    Kind kind;
    RegExp exp1;
    RegExp exp2;
    String s;
    int c;
    int min;
    int max;
    int digits;
    int from;
    int to;
    int flags;
    int pos;

    RegExp() {
        this.originalString = null;
    }

    public RegExp(String s2) throws IllegalArgumentException {
        this(s2, 65535);
    }

    public RegExp(String s2, int syntax_flags) throws IllegalArgumentException {
        RegExp e2;
        this.originalString = s2;
        this.flags = syntax_flags;
        if (s2.length() == 0) {
            e2 = RegExp.makeString("");
        } else {
            e2 = this.parseUnionExp();
            if (this.pos < this.originalString.length()) {
                throw new IllegalArgumentException("end-of-string expected at position " + this.pos);
            }
        }
        this.kind = e2.kind;
        this.exp1 = e2.exp1;
        this.exp2 = e2.exp2;
        this.s = e2.s;
        this.c = e2.c;
        this.min = e2.min;
        this.max = e2.max;
        this.digits = e2.digits;
        this.from = e2.from;
        this.to = e2.to;
    }

    public Automaton toAutomaton() {
        return this.toAutomaton(null, null, 10000);
    }

    public Automaton toAutomaton(int maxDeterminizedStates) throws IllegalArgumentException, TooComplexToDeterminizeException {
        return this.toAutomaton(null, null, maxDeterminizedStates);
    }

    public Automaton toAutomaton(AutomatonProvider automaton_provider, int maxDeterminizedStates) throws IllegalArgumentException, TooComplexToDeterminizeException {
        return this.toAutomaton(null, automaton_provider, maxDeterminizedStates);
    }

    public Automaton toAutomaton(Map<String, Automaton> automata, int maxDeterminizedStates) throws IllegalArgumentException, TooComplexToDeterminizeException {
        return this.toAutomaton(automata, null, maxDeterminizedStates);
    }

    private Automaton toAutomaton(Map<String, Automaton> automata, AutomatonProvider automaton_provider, int maxDeterminizedStates) throws IllegalArgumentException, TooComplexToDeterminizeException {
        try {
            return this.toAutomatonInternal(automata, automaton_provider, maxDeterminizedStates);
        }
        catch (TooComplexToDeterminizeException e2) {
            throw new TooComplexToDeterminizeException(this, e2);
        }
    }

    private Automaton toAutomatonInternal(Map<String, Automaton> automata, AutomatonProvider automaton_provider, int maxDeterminizedStates) throws IllegalArgumentException {
        Automaton a2 = null;
        switch (this.kind) {
            case REGEXP_UNION: {
                ArrayList<Automaton> list = new ArrayList<Automaton>();
                this.findLeaves(this.exp1, Kind.REGEXP_UNION, list, automata, automaton_provider, maxDeterminizedStates);
                this.findLeaves(this.exp2, Kind.REGEXP_UNION, list, automata, automaton_provider, maxDeterminizedStates);
                a2 = Operations.union(list);
                a2 = MinimizationOperations.minimize(a2, maxDeterminizedStates);
                break;
            }
            case REGEXP_CONCATENATION: {
                ArrayList<Automaton> list = new ArrayList<Automaton>();
                this.findLeaves(this.exp1, Kind.REGEXP_CONCATENATION, list, automata, automaton_provider, maxDeterminizedStates);
                this.findLeaves(this.exp2, Kind.REGEXP_CONCATENATION, list, automata, automaton_provider, maxDeterminizedStates);
                a2 = Operations.concatenate(list);
                a2 = MinimizationOperations.minimize(a2, maxDeterminizedStates);
                break;
            }
            case REGEXP_INTERSECTION: {
                a2 = Operations.intersection(this.exp1.toAutomatonInternal(automata, automaton_provider, maxDeterminizedStates), this.exp2.toAutomatonInternal(automata, automaton_provider, maxDeterminizedStates));
                a2 = MinimizationOperations.minimize(a2, maxDeterminizedStates);
                break;
            }
            case REGEXP_OPTIONAL: {
                a2 = Operations.optional(this.exp1.toAutomatonInternal(automata, automaton_provider, maxDeterminizedStates));
                a2 = MinimizationOperations.minimize(a2, maxDeterminizedStates);
                break;
            }
            case REGEXP_REPEAT: {
                a2 = Operations.repeat(this.exp1.toAutomatonInternal(automata, automaton_provider, maxDeterminizedStates));
                a2 = MinimizationOperations.minimize(a2, maxDeterminizedStates);
                break;
            }
            case REGEXP_REPEAT_MIN: {
                a2 = this.exp1.toAutomatonInternal(automata, automaton_provider, maxDeterminizedStates);
                int minNumStates = (a2.getNumStates() - 1) * this.min;
                if (minNumStates > maxDeterminizedStates) {
                    throw new TooComplexToDeterminizeException(a2, minNumStates);
                }
                a2 = Operations.repeat(a2, this.min);
                a2 = MinimizationOperations.minimize(a2, maxDeterminizedStates);
                break;
            }
            case REGEXP_REPEAT_MINMAX: {
                a2 = this.exp1.toAutomatonInternal(automata, automaton_provider, maxDeterminizedStates);
                int minMaxNumStates = (a2.getNumStates() - 1) * this.max;
                if (minMaxNumStates > maxDeterminizedStates) {
                    throw new TooComplexToDeterminizeException(a2, minMaxNumStates);
                }
                a2 = Operations.repeat(a2, this.min, this.max);
                break;
            }
            case REGEXP_COMPLEMENT: {
                a2 = Operations.complement(this.exp1.toAutomatonInternal(automata, automaton_provider, maxDeterminizedStates), maxDeterminizedStates);
                a2 = MinimizationOperations.minimize(a2, maxDeterminizedStates);
                break;
            }
            case REGEXP_CHAR: {
                a2 = Automata.makeChar(this.c);
                break;
            }
            case REGEXP_CHAR_RANGE: {
                a2 = Automata.makeCharRange(this.from, this.to);
                break;
            }
            case REGEXP_ANYCHAR: {
                a2 = Automata.makeAnyChar();
                break;
            }
            case REGEXP_EMPTY: {
                a2 = Automata.makeEmpty();
                break;
            }
            case REGEXP_STRING: {
                a2 = Automata.makeString(this.s);
                break;
            }
            case REGEXP_ANYSTRING: {
                a2 = Automata.makeAnyString();
                break;
            }
            case REGEXP_AUTOMATON: {
                Automaton aa2 = null;
                if (automata != null) {
                    aa2 = automata.get(this.s);
                }
                if (aa2 == null && automaton_provider != null) {
                    try {
                        aa2 = automaton_provider.getAutomaton(this.s);
                    }
                    catch (IOException e2) {
                        throw new IllegalArgumentException(e2);
                    }
                }
                if (aa2 == null) {
                    throw new IllegalArgumentException("'" + this.s + "' not found");
                }
                a2 = aa2;
                break;
            }
            case REGEXP_INTERVAL: {
                a2 = Automata.makeDecimalInterval(this.min, this.max, this.digits);
            }
        }
        return a2;
    }

    private void findLeaves(RegExp exp, Kind kind, List<Automaton> list, Map<String, Automaton> automata, AutomatonProvider automaton_provider, int maxDeterminizedStates) {
        if (exp.kind == kind) {
            this.findLeaves(exp.exp1, kind, list, automata, automaton_provider, maxDeterminizedStates);
            this.findLeaves(exp.exp2, kind, list, automata, automaton_provider, maxDeterminizedStates);
        } else {
            list.add(exp.toAutomatonInternal(automata, automaton_provider, maxDeterminizedStates));
        }
    }

    public String getOriginalString() {
        return this.originalString;
    }

    public String toString() {
        StringBuilder b2 = new StringBuilder();
        this.toStringBuilder(b2);
        return b2.toString();
    }

    void toStringBuilder(StringBuilder b2) {
        switch (this.kind) {
            case REGEXP_UNION: {
                b2.append("(");
                this.exp1.toStringBuilder(b2);
                b2.append("|");
                this.exp2.toStringBuilder(b2);
                b2.append(")");
                break;
            }
            case REGEXP_CONCATENATION: {
                this.exp1.toStringBuilder(b2);
                this.exp2.toStringBuilder(b2);
                break;
            }
            case REGEXP_INTERSECTION: {
                b2.append("(");
                this.exp1.toStringBuilder(b2);
                b2.append("&");
                this.exp2.toStringBuilder(b2);
                b2.append(")");
                break;
            }
            case REGEXP_OPTIONAL: {
                b2.append("(");
                this.exp1.toStringBuilder(b2);
                b2.append(")?");
                break;
            }
            case REGEXP_REPEAT: {
                b2.append("(");
                this.exp1.toStringBuilder(b2);
                b2.append(")*");
                break;
            }
            case REGEXP_REPEAT_MIN: {
                b2.append("(");
                this.exp1.toStringBuilder(b2);
                b2.append("){").append(this.min).append(",}");
                break;
            }
            case REGEXP_REPEAT_MINMAX: {
                b2.append("(");
                this.exp1.toStringBuilder(b2);
                b2.append("){").append(this.min).append(",").append(this.max).append("}");
                break;
            }
            case REGEXP_COMPLEMENT: {
                b2.append("~(");
                this.exp1.toStringBuilder(b2);
                b2.append(")");
                break;
            }
            case REGEXP_CHAR: {
                b2.append("\\").appendCodePoint(this.c);
                break;
            }
            case REGEXP_CHAR_RANGE: {
                b2.append("[\\").appendCodePoint(this.from).append("-\\").appendCodePoint(this.to).append("]");
                break;
            }
            case REGEXP_ANYCHAR: {
                b2.append(".");
                break;
            }
            case REGEXP_EMPTY: {
                b2.append("#");
                break;
            }
            case REGEXP_STRING: {
                b2.append("\"").append(this.s).append("\"");
                break;
            }
            case REGEXP_ANYSTRING: {
                b2.append("@");
                break;
            }
            case REGEXP_AUTOMATON: {
                b2.append("<").append(this.s).append(">");
                break;
            }
            case REGEXP_INTERVAL: {
                int i2;
                String s1 = Integer.toString(this.min);
                String s2 = Integer.toString(this.max);
                b2.append("<");
                if (this.digits > 0) {
                    for (i2 = s1.length(); i2 < this.digits; ++i2) {
                        b2.append('0');
                    }
                }
                b2.append(s1).append("-");
                if (this.digits > 0) {
                    for (i2 = s2.length(); i2 < this.digits; ++i2) {
                        b2.append('0');
                    }
                }
                b2.append(s2).append(">");
            }
        }
    }

    public String toStringTree() {
        StringBuilder b2 = new StringBuilder();
        this.toStringTree(b2, "");
        return b2.toString();
    }

    void toStringTree(StringBuilder b2, String indent) {
        switch (this.kind) {
            case REGEXP_UNION: 
            case REGEXP_CONCATENATION: 
            case REGEXP_INTERSECTION: {
                b2.append(indent);
                b2.append((Object)this.kind);
                b2.append('\n');
                this.exp1.toStringTree(b2, indent + "  ");
                this.exp2.toStringTree(b2, indent + "  ");
                break;
            }
            case REGEXP_OPTIONAL: 
            case REGEXP_REPEAT: 
            case REGEXP_COMPLEMENT: {
                b2.append(indent);
                b2.append((Object)this.kind);
                b2.append('\n');
                this.exp1.toStringTree(b2, indent + "  ");
                break;
            }
            case REGEXP_REPEAT_MIN: {
                b2.append(indent);
                b2.append((Object)this.kind);
                b2.append(" min=");
                b2.append(this.min);
                b2.append('\n');
                this.exp1.toStringTree(b2, indent + "  ");
                break;
            }
            case REGEXP_REPEAT_MINMAX: {
                b2.append(indent);
                b2.append((Object)this.kind);
                b2.append(" min=");
                b2.append(this.min);
                b2.append(" max=");
                b2.append(this.max);
                b2.append('\n');
                this.exp1.toStringTree(b2, indent + "  ");
                break;
            }
            case REGEXP_CHAR: {
                b2.append(indent);
                b2.append((Object)this.kind);
                b2.append(" char=");
                b2.appendCodePoint(this.c);
                b2.append('\n');
                break;
            }
            case REGEXP_CHAR_RANGE: {
                b2.append(indent);
                b2.append((Object)this.kind);
                b2.append(" from=");
                b2.appendCodePoint(this.from);
                b2.append(" to=");
                b2.appendCodePoint(this.to);
                b2.append('\n');
                break;
            }
            case REGEXP_ANYCHAR: 
            case REGEXP_EMPTY: {
                b2.append(indent);
                b2.append((Object)this.kind);
                b2.append('\n');
                break;
            }
            case REGEXP_STRING: {
                b2.append(indent);
                b2.append((Object)this.kind);
                b2.append(" string=");
                b2.append(this.s);
                b2.append('\n');
                break;
            }
            case REGEXP_ANYSTRING: {
                b2.append(indent);
                b2.append((Object)this.kind);
                b2.append('\n');
                break;
            }
            case REGEXP_AUTOMATON: {
                b2.append(indent);
                b2.append((Object)this.kind);
                b2.append('\n');
                break;
            }
            case REGEXP_INTERVAL: {
                int i2;
                b2.append(indent);
                b2.append((Object)this.kind);
                String s1 = Integer.toString(this.min);
                String s2 = Integer.toString(this.max);
                b2.append("<");
                if (this.digits > 0) {
                    for (i2 = s1.length(); i2 < this.digits; ++i2) {
                        b2.append('0');
                    }
                }
                b2.append(s1).append("-");
                if (this.digits > 0) {
                    for (i2 = s2.length(); i2 < this.digits; ++i2) {
                        b2.append('0');
                    }
                }
                b2.append(s2).append(">");
                b2.append('\n');
            }
        }
    }

    public Set<String> getIdentifiers() {
        HashSet<String> set = new HashSet<String>();
        this.getIdentifiers(set);
        return set;
    }

    void getIdentifiers(Set<String> set) {
        switch (this.kind) {
            case REGEXP_UNION: 
            case REGEXP_CONCATENATION: 
            case REGEXP_INTERSECTION: {
                this.exp1.getIdentifiers(set);
                this.exp2.getIdentifiers(set);
                break;
            }
            case REGEXP_OPTIONAL: 
            case REGEXP_REPEAT: 
            case REGEXP_REPEAT_MIN: 
            case REGEXP_REPEAT_MINMAX: 
            case REGEXP_COMPLEMENT: {
                this.exp1.getIdentifiers(set);
                break;
            }
            case REGEXP_AUTOMATON: {
                set.add(this.s);
                break;
            }
        }
    }

    static RegExp makeUnion(RegExp exp1, RegExp exp2) {
        RegExp r2 = new RegExp();
        r2.kind = Kind.REGEXP_UNION;
        r2.exp1 = exp1;
        r2.exp2 = exp2;
        return r2;
    }

    static RegExp makeConcatenation(RegExp exp1, RegExp exp2) {
        if (!(exp1.kind != Kind.REGEXP_CHAR && exp1.kind != Kind.REGEXP_STRING || exp2.kind != Kind.REGEXP_CHAR && exp2.kind != Kind.REGEXP_STRING)) {
            return RegExp.makeString(exp1, exp2);
        }
        RegExp r2 = new RegExp();
        r2.kind = Kind.REGEXP_CONCATENATION;
        if (!(exp1.kind != Kind.REGEXP_CONCATENATION || exp1.exp2.kind != Kind.REGEXP_CHAR && exp1.exp2.kind != Kind.REGEXP_STRING || exp2.kind != Kind.REGEXP_CHAR && exp2.kind != Kind.REGEXP_STRING)) {
            r2.exp1 = exp1.exp1;
            r2.exp2 = RegExp.makeString(exp1.exp2, exp2);
        } else if (!(exp1.kind != Kind.REGEXP_CHAR && exp1.kind != Kind.REGEXP_STRING || exp2.kind != Kind.REGEXP_CONCATENATION || exp2.exp1.kind != Kind.REGEXP_CHAR && exp2.exp1.kind != Kind.REGEXP_STRING)) {
            r2.exp1 = RegExp.makeString(exp1, exp2.exp1);
            r2.exp2 = exp2.exp2;
        } else {
            r2.exp1 = exp1;
            r2.exp2 = exp2;
        }
        return r2;
    }

    private static RegExp makeString(RegExp exp1, RegExp exp2) {
        StringBuilder b2 = new StringBuilder();
        if (exp1.kind == Kind.REGEXP_STRING) {
            b2.append(exp1.s);
        } else {
            b2.appendCodePoint(exp1.c);
        }
        if (exp2.kind == Kind.REGEXP_STRING) {
            b2.append(exp2.s);
        } else {
            b2.appendCodePoint(exp2.c);
        }
        return RegExp.makeString(b2.toString());
    }

    static RegExp makeIntersection(RegExp exp1, RegExp exp2) {
        RegExp r2 = new RegExp();
        r2.kind = Kind.REGEXP_INTERSECTION;
        r2.exp1 = exp1;
        r2.exp2 = exp2;
        return r2;
    }

    static RegExp makeOptional(RegExp exp) {
        RegExp r2 = new RegExp();
        r2.kind = Kind.REGEXP_OPTIONAL;
        r2.exp1 = exp;
        return r2;
    }

    static RegExp makeRepeat(RegExp exp) {
        RegExp r2 = new RegExp();
        r2.kind = Kind.REGEXP_REPEAT;
        r2.exp1 = exp;
        return r2;
    }

    static RegExp makeRepeat(RegExp exp, int min2) {
        RegExp r2 = new RegExp();
        r2.kind = Kind.REGEXP_REPEAT_MIN;
        r2.exp1 = exp;
        r2.min = min2;
        return r2;
    }

    static RegExp makeRepeat(RegExp exp, int min2, int max) {
        RegExp r2 = new RegExp();
        r2.kind = Kind.REGEXP_REPEAT_MINMAX;
        r2.exp1 = exp;
        r2.min = min2;
        r2.max = max;
        return r2;
    }

    static RegExp makeComplement(RegExp exp) {
        RegExp r2 = new RegExp();
        r2.kind = Kind.REGEXP_COMPLEMENT;
        r2.exp1 = exp;
        return r2;
    }

    static RegExp makeChar(int c2) {
        RegExp r2 = new RegExp();
        r2.kind = Kind.REGEXP_CHAR;
        r2.c = c2;
        return r2;
    }

    static RegExp makeCharRange(int from, int to) {
        if (from > to) {
            throw new IllegalArgumentException("invalid range: from (" + from + ") cannot be > to (" + to + ")");
        }
        RegExp r2 = new RegExp();
        r2.kind = Kind.REGEXP_CHAR_RANGE;
        r2.from = from;
        r2.to = to;
        return r2;
    }

    static RegExp makeAnyChar() {
        RegExp r2 = new RegExp();
        r2.kind = Kind.REGEXP_ANYCHAR;
        return r2;
    }

    static RegExp makeEmpty() {
        RegExp r2 = new RegExp();
        r2.kind = Kind.REGEXP_EMPTY;
        return r2;
    }

    static RegExp makeString(String s2) {
        RegExp r2 = new RegExp();
        r2.kind = Kind.REGEXP_STRING;
        r2.s = s2;
        return r2;
    }

    static RegExp makeAnyString() {
        RegExp r2 = new RegExp();
        r2.kind = Kind.REGEXP_ANYSTRING;
        return r2;
    }

    static RegExp makeAutomaton(String s2) {
        RegExp r2 = new RegExp();
        r2.kind = Kind.REGEXP_AUTOMATON;
        r2.s = s2;
        return r2;
    }

    static RegExp makeInterval(int min2, int max, int digits) {
        RegExp r2 = new RegExp();
        r2.kind = Kind.REGEXP_INTERVAL;
        r2.min = min2;
        r2.max = max;
        r2.digits = digits;
        return r2;
    }

    private boolean peek(String s2) {
        return this.more() && s2.indexOf(this.originalString.codePointAt(this.pos)) != -1;
    }

    private boolean match(int c2) {
        if (this.pos >= this.originalString.length()) {
            return false;
        }
        if (this.originalString.codePointAt(this.pos) == c2) {
            this.pos += Character.charCount(c2);
            return true;
        }
        return false;
    }

    private boolean more() {
        return this.pos < this.originalString.length();
    }

    private int next() throws IllegalArgumentException {
        if (!this.more()) {
            throw new IllegalArgumentException("unexpected end-of-string");
        }
        int ch = this.originalString.codePointAt(this.pos);
        this.pos += Character.charCount(ch);
        return ch;
    }

    private boolean check(int flag) {
        return (this.flags & flag) != 0;
    }

    final RegExp parseUnionExp() throws IllegalArgumentException {
        RegExp e2 = this.parseInterExp();
        if (this.match(124)) {
            e2 = RegExp.makeUnion(e2, this.parseUnionExp());
        }
        return e2;
    }

    final RegExp parseInterExp() throws IllegalArgumentException {
        RegExp e2 = this.parseConcatExp();
        if (this.check(1) && this.match(38)) {
            e2 = RegExp.makeIntersection(e2, this.parseInterExp());
        }
        return e2;
    }

    final RegExp parseConcatExp() throws IllegalArgumentException {
        RegExp e2 = this.parseRepeatExp();
        if (!(!this.more() || this.peek(")|") || this.check(1) && this.peek("&"))) {
            e2 = RegExp.makeConcatenation(e2, this.parseConcatExp());
        }
        return e2;
    }

    final RegExp parseRepeatExp() throws IllegalArgumentException {
        RegExp e2 = this.parseComplExp();
        while (this.peek("?*+{")) {
            if (this.match(63)) {
                e2 = RegExp.makeOptional(e2);
                continue;
            }
            if (this.match(42)) {
                e2 = RegExp.makeRepeat(e2);
                continue;
            }
            if (this.match(43)) {
                e2 = RegExp.makeRepeat(e2, 1);
                continue;
            }
            if (!this.match(123)) continue;
            int start = this.pos;
            while (this.peek("0123456789")) {
                this.next();
            }
            if (start == this.pos) {
                throw new IllegalArgumentException("integer expected at position " + this.pos);
            }
            int n2 = Integer.parseInt(this.originalString.substring(start, this.pos));
            int m3 = -1;
            if (this.match(44)) {
                start = this.pos;
                while (this.peek("0123456789")) {
                    this.next();
                }
                if (start != this.pos) {
                    m3 = Integer.parseInt(this.originalString.substring(start, this.pos));
                }
            } else {
                m3 = n2;
            }
            if (!this.match(125)) {
                throw new IllegalArgumentException("expected '}' at position " + this.pos);
            }
            if (m3 == -1) {
                e2 = RegExp.makeRepeat(e2, n2);
                continue;
            }
            e2 = RegExp.makeRepeat(e2, n2, m3);
        }
        return e2;
    }

    final RegExp parseComplExp() throws IllegalArgumentException {
        if (this.check(2) && this.match(126)) {
            return RegExp.makeComplement(this.parseComplExp());
        }
        return this.parseCharClassExp();
    }

    final RegExp parseCharClassExp() throws IllegalArgumentException {
        if (this.match(91)) {
            boolean negate = false;
            if (this.match(94)) {
                negate = true;
            }
            RegExp e2 = this.parseCharClasses();
            if (negate) {
                e2 = RegExp.makeIntersection(RegExp.makeAnyChar(), RegExp.makeComplement(e2));
            }
            if (!this.match(93)) {
                throw new IllegalArgumentException("expected ']' at position " + this.pos);
            }
            return e2;
        }
        return this.parseSimpleExp();
    }

    final RegExp parseCharClasses() throws IllegalArgumentException {
        RegExp e2 = this.parseCharClass();
        while (this.more() && !this.peek("]")) {
            e2 = RegExp.makeUnion(e2, this.parseCharClass());
        }
        return e2;
    }

    final RegExp parseCharClass() throws IllegalArgumentException {
        int c2 = this.parseCharExp();
        if (this.match(45)) {
            return RegExp.makeCharRange(c2, this.parseCharExp());
        }
        return RegExp.makeChar(c2);
    }

    final RegExp parseSimpleExp() throws IllegalArgumentException {
        if (this.match(46)) {
            return RegExp.makeAnyChar();
        }
        if (this.check(4) && this.match(35)) {
            return RegExp.makeEmpty();
        }
        if (this.check(8) && this.match(64)) {
            return RegExp.makeAnyString();
        }
        if (this.match(34)) {
            int start = this.pos;
            while (this.more() && !this.peek("\"")) {
                this.next();
            }
            if (!this.match(34)) {
                throw new IllegalArgumentException("expected '\"' at position " + this.pos);
            }
            return RegExp.makeString(this.originalString.substring(start, this.pos - 1));
        }
        if (this.match(40)) {
            if (this.match(41)) {
                return RegExp.makeString("");
            }
            RegExp e2 = this.parseUnionExp();
            if (!this.match(41)) {
                throw new IllegalArgumentException("expected ')' at position " + this.pos);
            }
            return e2;
        }
        if ((this.check(16) || this.check(32)) && this.match(60)) {
            int start = this.pos;
            while (this.more() && !this.peek(">")) {
                this.next();
            }
            if (!this.match(62)) {
                throw new IllegalArgumentException("expected '>' at position " + this.pos);
            }
            String s2 = this.originalString.substring(start, this.pos - 1);
            int i2 = s2.indexOf(45);
            if (i2 == -1) {
                if (!this.check(16)) {
                    throw new IllegalArgumentException("interval syntax error at position " + (this.pos - 1));
                }
                return RegExp.makeAutomaton(s2);
            }
            if (!this.check(32)) {
                throw new IllegalArgumentException("illegal identifier at position " + (this.pos - 1));
            }
            try {
                if (i2 == 0 || i2 == s2.length() - 1 || i2 != s2.lastIndexOf(45)) {
                    throw new NumberFormatException();
                }
                String smin = s2.substring(0, i2);
                String smax = s2.substring(i2 + 1, s2.length());
                int imin = Integer.parseInt(smin);
                int imax = Integer.parseInt(smax);
                int digits = smin.length() == smax.length() ? smin.length() : 0;
                if (imin > imax) {
                    int t2 = imin;
                    imin = imax;
                    imax = t2;
                }
                return RegExp.makeInterval(imin, imax, digits);
            }
            catch (NumberFormatException e3) {
                throw new IllegalArgumentException("interval syntax error at position " + (this.pos - 1));
            }
        }
        return RegExp.makeChar(this.parseCharExp());
    }

    final int parseCharExp() throws IllegalArgumentException {
        this.match(92);
        return this.next();
    }

    static enum Kind {
        REGEXP_UNION,
        REGEXP_CONCATENATION,
        REGEXP_INTERSECTION,
        REGEXP_OPTIONAL,
        REGEXP_REPEAT,
        REGEXP_REPEAT_MIN,
        REGEXP_REPEAT_MINMAX,
        REGEXP_COMPLEMENT,
        REGEXP_CHAR,
        REGEXP_CHAR_RANGE,
        REGEXP_ANYCHAR,
        REGEXP_EMPTY,
        REGEXP_STRING,
        REGEXP_ANYSTRING,
        REGEXP_AUTOMATON,
        REGEXP_INTERVAL;

    }
}

