/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util.automaton;

import java.util.Arrays;
import org.apache.lucene.util.automaton.Automaton;
import org.apache.lucene.util.automaton.Operations;

public abstract class RunAutomaton {
    final Automaton automaton;
    final int alphabetSize;
    final int size;
    final boolean[] accept;
    final int[] transitions;
    final int[] points;
    final int[] classmap;

    protected RunAutomaton(Automaton a2, int alphabetSize) {
        this(a2, alphabetSize, 10000);
    }

    protected RunAutomaton(Automaton a2, int alphabetSize, int maxDeterminizedStates) {
        this.alphabetSize = alphabetSize;
        this.automaton = a2 = Operations.determinize(a2, maxDeterminizedStates);
        this.points = a2.getStartPoints();
        this.size = Math.max(1, a2.getNumStates());
        this.accept = new boolean[this.size];
        this.transitions = new int[this.size * this.points.length];
        Arrays.fill(this.transitions, -1);
        for (int n2 = 0; n2 < this.size; ++n2) {
            this.accept[n2] = a2.isAccept(n2);
            for (int c2 = 0; c2 < this.points.length; ++c2) {
                int dest = a2.step(n2, this.points[c2]);
                assert (dest == -1 || dest < this.size);
                this.transitions[n2 * this.points.length + c2] = dest;
            }
        }
        this.classmap = new int[Math.min(256, alphabetSize)];
        int i2 = 0;
        for (int j2 = 0; j2 < this.classmap.length; ++j2) {
            if (i2 + 1 >= this.points.length || j2 == this.points[i2 + 1]) {
                // empty if block
            }
            this.classmap[j2] = ++i2;
        }
    }

    public String toString() {
        StringBuilder b2 = new StringBuilder();
        b2.append("initial state: 0\n");
        for (int i2 = 0; i2 < this.size; ++i2) {
            b2.append("state " + i2);
            if (this.accept[i2]) {
                b2.append(" [accept]:\n");
            } else {
                b2.append(" [reject]:\n");
            }
            for (int j2 = 0; j2 < this.points.length; ++j2) {
                int k2 = this.transitions[i2 * this.points.length + j2];
                if (k2 == -1) continue;
                int min2 = this.points[j2];
                int max = j2 + 1 < this.points.length ? this.points[j2 + 1] - 1 : this.alphabetSize;
                b2.append(" ");
                Automaton.appendCharString(min2, b2);
                if (min2 != max) {
                    b2.append("-");
                    Automaton.appendCharString(max, b2);
                }
                b2.append(" -> ").append(k2).append("\n");
            }
        }
        return b2.toString();
    }

    public final int getSize() {
        return this.size;
    }

    public final boolean isAccept(int state) {
        return this.accept[state];
    }

    public final int[] getCharIntervals() {
        return (int[])this.points.clone();
    }

    final int getCharClass(int c2) {
        int a2 = 0;
        int b2 = this.points.length;
        while (b2 - a2 > 1) {
            int d2 = a2 + b2 >>> 1;
            if (this.points[d2] > c2) {
                b2 = d2;
                continue;
            }
            if (this.points[d2] < c2) {
                a2 = d2;
                continue;
            }
            return d2;
        }
        return a2;
    }

    public final int step(int state, int c2) {
        assert (c2 < this.alphabetSize);
        if (c2 >= this.classmap.length) {
            return this.transitions[state * this.points.length + this.getCharClass(c2)];
        }
        return this.transitions[state * this.points.length + this.classmap[c2]];
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.alphabetSize;
        result = 31 * result + this.points.length;
        result = 31 * result + this.size;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RunAutomaton other = (RunAutomaton)obj;
        if (this.alphabetSize != other.alphabetSize) {
            return false;
        }
        if (this.size != other.size) {
            return false;
        }
        if (!Arrays.equals(this.points, other.points)) {
            return false;
        }
        if (!Arrays.equals(this.accept, other.accept)) {
            return false;
        }
        return Arrays.equals(this.transitions, other.transitions);
    }
}

