/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util.fst;

import org.apache.lucene.util.fst.FST;

final class ReverseBytesReader
extends FST.BytesReader {
    private final byte[] bytes;
    private int pos;

    public ReverseBytesReader(byte[] bytes) {
        this.bytes = bytes;
    }

    @Override
    public byte readByte() {
        return this.bytes[this.pos--];
    }

    @Override
    public void readBytes(byte[] b2, int offset, int len) {
        for (int i2 = 0; i2 < len; ++i2) {
            b2[offset + i2] = this.bytes[this.pos--];
        }
    }

    @Override
    public void skipBytes(long count) {
        this.pos = (int)((long)this.pos - count);
    }

    @Override
    public long getPosition() {
        return this.pos;
    }

    @Override
    public void setPosition(long pos) {
        this.pos = (int)pos;
    }

    @Override
    public boolean reversed() {
        return true;
    }
}

