/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util.mutable;

import org.apache.lucene.util.mutable.MutableValue;

public class MutableValueFloat
extends MutableValue {
    public float value;

    @Override
    public Object toObject() {
        assert (this.exists || 0.0f == this.value);
        return this.exists ? Float.valueOf(this.value) : null;
    }

    @Override
    public void copy(MutableValue source) {
        MutableValueFloat s2 = (MutableValueFloat)source;
        this.value = s2.value;
        this.exists = s2.exists;
    }

    @Override
    public MutableValue duplicate() {
        MutableValueFloat v2 = new MutableValueFloat();
        v2.value = this.value;
        v2.exists = this.exists;
        return v2;
    }

    @Override
    public boolean equalsSameType(Object other) {
        assert (this.exists || 0.0f == this.value);
        MutableValueFloat b2 = (MutableValueFloat)other;
        return this.value == b2.value && this.exists == b2.exists;
    }

    @Override
    public int compareSameType(Object other) {
        assert (this.exists || 0.0f == this.value);
        MutableValueFloat b2 = (MutableValueFloat)other;
        int c2 = Float.compare(this.value, b2.value);
        if (c2 != 0) {
            return c2;
        }
        if (this.exists == b2.exists) {
            return 0;
        }
        return this.exists ? 1 : -1;
    }

    @Override
    public int hashCode() {
        assert (this.exists || 0.0f == this.value);
        return Float.floatToIntBits(this.value);
    }
}

