/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util.packed;

import org.apache.lucene.util.packed.BulkOperationPacked;

final class BulkOperationPacked8
extends BulkOperationPacked {
    public BulkOperationPacked8() {
        super(8);
    }

    @Override
    public void decode(long[] blocks, int blocksOffset, int[] values, int valuesOffset, int iterations) {
        for (int i2 = 0; i2 < iterations; ++i2) {
            long block = blocks[blocksOffset++];
            for (int shift = 56; shift >= 0; shift -= 8) {
                values[valuesOffset++] = (int)(block >>> shift & 0xFFL);
            }
        }
    }

    @Override
    public void decode(byte[] blocks, int blocksOffset, int[] values, int valuesOffset, int iterations) {
        for (int j2 = 0; j2 < iterations; ++j2) {
            values[valuesOffset++] = blocks[blocksOffset++] & 0xFF;
        }
    }

    @Override
    public void decode(long[] blocks, int blocksOffset, long[] values, int valuesOffset, int iterations) {
        for (int i2 = 0; i2 < iterations; ++i2) {
            long block = blocks[blocksOffset++];
            for (int shift = 56; shift >= 0; shift -= 8) {
                values[valuesOffset++] = block >>> shift & 0xFFL;
            }
        }
    }

    @Override
    public void decode(byte[] blocks, int blocksOffset, long[] values, int valuesOffset, int iterations) {
        for (int j2 = 0; j2 < iterations; ++j2) {
            values[valuesOffset++] = blocks[blocksOffset++] & 0xFF;
        }
    }
}

