/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util.packed;

import java.util.Arrays;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.RamUsageEstimator;
import org.apache.lucene.util.packed.DeltaPackedLongValues;
import org.apache.lucene.util.packed.MonotonicBlockPackedReader;
import org.apache.lucene.util.packed.PackedInts;

class MonotonicLongValues
extends DeltaPackedLongValues {
    private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(MonotonicLongValues.class);
    final float[] averages;

    MonotonicLongValues(int pageShift, int pageMask, PackedInts.Reader[] values, long[] mins, float[] averages, long size, long ramBytesUsed) {
        super(pageShift, pageMask, values, mins, size, ramBytesUsed);
        assert (values.length == averages.length);
        this.averages = averages;
    }

    @Override
    long get(int block, int element) {
        return MonotonicBlockPackedReader.expected(this.mins[block], this.averages[block], element) + this.values[block].get(element);
    }

    @Override
    int decodeBlock(int block, long[] dest) {
        int count = super.decodeBlock(block, dest);
        float average = this.averages[block];
        for (int i2 = 0; i2 < count; ++i2) {
            int n2 = i2;
            dest[n2] = dest[n2] + MonotonicBlockPackedReader.expected(0L, average, i2);
        }
        return count;
    }

    static class Builder
    extends DeltaPackedLongValues.Builder {
        private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(Builder.class);
        float[] averages;

        Builder(int pageSize, float acceptableOverheadRatio) {
            super(pageSize, acceptableOverheadRatio);
            this.averages = new float[this.values.length];
            this.ramBytesUsed += RamUsageEstimator.sizeOf(this.averages);
        }

        @Override
        long baseRamBytesUsed() {
            return BASE_RAM_BYTES_USED;
        }

        @Override
        public MonotonicLongValues build() {
            this.finish();
            this.pending = null;
            Accountable[] values = Arrays.copyOf(this.values, this.valuesOff);
            long[] mins = Arrays.copyOf(this.mins, this.valuesOff);
            float[] averages = Arrays.copyOf(this.averages, this.valuesOff);
            long ramBytesUsed = BASE_RAM_BYTES_USED + RamUsageEstimator.sizeOf(values) + RamUsageEstimator.sizeOf(mins) + RamUsageEstimator.sizeOf(averages);
            return new MonotonicLongValues(this.pageShift, this.pageMask, (PackedInts.Reader[])values, mins, averages, this.size, ramBytesUsed);
        }

        @Override
        void pack(long[] values, int numValues, int block, float acceptableOverheadRatio) {
            float average = numValues == 1 ? 0.0f : (float)(values[numValues - 1] - values[0]) / (float)(numValues - 1);
            for (int i2 = 0; i2 < numValues; ++i2) {
                int n2 = i2;
                values[n2] = values[n2] - MonotonicBlockPackedReader.expected(0L, average, i2);
            }
            super.pack(values, numValues, block, acceptableOverheadRatio);
            this.averages[block] = average;
        }

        @Override
        void grow(int newBlockCount) {
            super.grow(newBlockCount);
            this.ramBytesUsed -= RamUsageEstimator.sizeOf(this.averages);
            this.averages = Arrays.copyOf(this.averages, newBlockCount);
            this.ramBytesUsed += RamUsageEstimator.sizeOf(this.averages);
        }
    }
}

