/*
 * Decompiled with CFR 0.152.
 */
package org.stringtemplate.v4;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Locale;
import org.stringtemplate.v4.AttributeRenderer;

public class StringRenderer
implements AttributeRenderer {
    public String toString(Object o2, String formatString, Locale locale) {
        String s2 = (String)o2;
        if (formatString == null) {
            return s2;
        }
        if (formatString.equals("upper")) {
            return s2.toUpperCase(locale);
        }
        if (formatString.equals("lower")) {
            return s2.toLowerCase(locale);
        }
        if (formatString.equals("cap")) {
            return s2.length() > 0 ? Character.toUpperCase(s2.charAt(0)) + s2.substring(1) : s2;
        }
        if (formatString.equals("url-encode")) {
            try {
                return URLEncoder.encode(s2, "UTF-8");
            }
            catch (UnsupportedEncodingException ex) {
                // empty catch block
            }
        }
        if (formatString.equals("xml-encode")) {
            return StringRenderer.escapeHTML(s2);
        }
        return String.format(locale, formatString, s2);
    }

    public static String escapeHTML(String s2) {
        if (s2 == null) {
            return null;
        }
        StringBuilder buf = new StringBuilder(s2.length());
        int len = s2.length();
        block6: for (int i2 = 0; i2 < len; ++i2) {
            char c2 = s2.charAt(i2);
            switch (c2) {
                case '&': {
                    buf.append("&amp;");
                    continue block6;
                }
                case '<': {
                    buf.append("&lt;");
                    continue block6;
                }
                case '>': {
                    buf.append("&gt;");
                    continue block6;
                }
                case '\t': 
                case '\n': 
                case '\r': {
                    buf.append(c2);
                    continue block6;
                }
                default: {
                    boolean aboveASCII;
                    boolean control = c2 < ' ';
                    boolean bl = aboveASCII = c2 > '~';
                    if (control || aboveASCII) {
                        buf.append("&#");
                        buf.append((int)c2);
                        buf.append(";");
                        continue block6;
                    }
                    buf.append(c2);
                }
            }
        }
        return buf.toString();
    }
}

