/*
 * Decompiled with CFR 0.152.
 */
package org.stringtemplate.v4.misc;

import org.antlr.runtime.CharStream;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.Token;
import org.stringtemplate.v4.InstanceScope;
import org.stringtemplate.v4.Interpreter;
import org.stringtemplate.v4.ST;
import org.stringtemplate.v4.STErrorListener;
import org.stringtemplate.v4.misc.ErrorType;
import org.stringtemplate.v4.misc.Misc;
import org.stringtemplate.v4.misc.STCompiletimeMessage;
import org.stringtemplate.v4.misc.STGroupCompiletimeMessage;
import org.stringtemplate.v4.misc.STLexerMessage;
import org.stringtemplate.v4.misc.STMessage;
import org.stringtemplate.v4.misc.STRuntimeMessage;

public class ErrorManager {
    public static STErrorListener DEFAULT_ERROR_LISTENER = new STErrorListener(){

        public void compileTimeError(STMessage msg) {
            System.err.println(msg);
        }

        public void runTimeError(STMessage msg) {
            if (msg.error != ErrorType.NO_SUCH_PROPERTY) {
                System.err.println(msg);
            }
        }

        public void IOError(STMessage msg) {
            System.err.println(msg);
        }

        public void internalError(STMessage msg) {
            System.err.println(msg);
        }

        public void error(String s2) {
            this.error(s2, null);
        }

        public void error(String s2, Throwable e2) {
            System.err.println(s2);
            if (e2 != null) {
                e2.printStackTrace(System.err);
            }
        }
    };
    public final STErrorListener listener;

    public ErrorManager() {
        this(DEFAULT_ERROR_LISTENER);
    }

    public ErrorManager(STErrorListener listener) {
        this.listener = listener;
    }

    public void compileTimeError(ErrorType error, Token templateToken, Token t2) {
        CharStream input = t2.getInputStream();
        String srcName = null;
        if (input != null && (srcName = input.getSourceName()) != null) {
            srcName = Misc.getFileName(srcName);
        }
        this.listener.compileTimeError(new STCompiletimeMessage(error, srcName, templateToken, t2, null, (Object)t2.getText()));
    }

    public void lexerError(String srcName, String msg, Token templateToken, RecognitionException e2) {
        if (srcName != null) {
            srcName = Misc.getFileName(srcName);
        }
        this.listener.compileTimeError(new STLexerMessage(srcName, msg, templateToken, e2));
    }

    public void compileTimeError(ErrorType error, Token templateToken, Token t2, Object arg) {
        String srcName = t2.getInputStream().getSourceName();
        if (srcName != null) {
            srcName = Misc.getFileName(srcName);
        }
        this.listener.compileTimeError(new STCompiletimeMessage(error, srcName, templateToken, t2, null, arg));
    }

    public void compileTimeError(ErrorType error, Token templateToken, Token t2, Object arg, Object arg2) {
        String srcName = t2.getInputStream().getSourceName();
        if (srcName != null) {
            srcName = Misc.getFileName(srcName);
        }
        this.listener.compileTimeError(new STCompiletimeMessage(error, srcName, templateToken, t2, null, arg, arg2));
    }

    public void groupSyntaxError(ErrorType error, String srcName, RecognitionException e2, String msg) {
        Token t2 = e2.token;
        this.listener.compileTimeError(new STGroupCompiletimeMessage(error, srcName, e2.token, e2, (Object)msg));
    }

    public void groupLexerError(ErrorType error, String srcName, RecognitionException e2, String msg) {
        this.listener.compileTimeError(new STGroupCompiletimeMessage(error, srcName, e2.token, e2, (Object)msg));
    }

    public void runTimeError(Interpreter interp, InstanceScope scope, ErrorType error) {
        this.listener.runTimeError(new STRuntimeMessage(interp, error, scope != null ? scope.ip : 0, scope));
    }

    public void runTimeError(Interpreter interp, InstanceScope scope, ErrorType error, Object arg) {
        this.listener.runTimeError(new STRuntimeMessage(interp, error, scope != null ? scope.ip : 0, scope, arg));
    }

    public void runTimeError(Interpreter interp, InstanceScope scope, ErrorType error, Throwable e2, Object arg) {
        this.listener.runTimeError(new STRuntimeMessage(interp, error, scope != null ? scope.ip : 0, scope, e2, arg));
    }

    public void runTimeError(Interpreter interp, InstanceScope scope, ErrorType error, Object arg, Object arg2) {
        this.listener.runTimeError(new STRuntimeMessage(interp, error, scope != null ? scope.ip : 0, scope, null, arg, arg2));
    }

    public void runTimeError(Interpreter interp, InstanceScope scope, ErrorType error, Object arg, Object arg2, Object arg3) {
        this.listener.runTimeError(new STRuntimeMessage(interp, error, scope != null ? scope.ip : 0, scope, null, arg, arg2, arg3));
    }

    public void IOError(ST self, ErrorType error, Throwable e2) {
        this.listener.IOError(new STMessage(error, self, e2));
    }

    public void IOError(ST self, ErrorType error, Throwable e2, Object arg) {
        this.listener.IOError(new STMessage(error, self, e2, arg));
    }

    public void internalError(ST self, String msg, Throwable e2) {
        this.listener.internalError(new STMessage(ErrorType.INTERNAL_ERROR, self, e2, msg));
    }
}

