var markerIds = [];
var breakPointMarkerIds = [];
function initEditor(theme, language, isReadOnly){
    try{
        window.language = language;
        editor = ace.edit("editor");
        Range = ace.require('ace/range').Range;
        editor.setTheme("ace/theme/" + theme);
        editor.setScrollSpeed(0.01);
        var modelist = ace.require("ace/ext/modelist");
        var mode = modelist.getModeForPath("abc." + language).mode
        editor.session.setMode(mode);
        editor.setReadOnly(isReadOnly);
        editor.resize(true);
        editor.setOptions({
            enableBasicAutocompletion: true,
            enableSnippets: true,
            enableLiveAutocompletion: true
        });
        editor.getSession().on('change', function() {
            bridge.textChange();
        });
        if(language != 'java' && language != 'css' && language != 'html' && language != 'js' && language != 'sql' && language != 'ts' && language != 'jsx'){
            return;
        }
        if(!isReadOnly && (language == 'java' || language == 'js' || language == 'ts')) {
            editor.on("guttermousedown", function (e) {
                var target = e.domEvent.target;
                if (target.className.indexOf("ace_gutter-cell") == -1)
                    return;
                if (!editor.isFocused())
                    return;
                if (e.clientX > 25 + target.getBoundingClientRect().left)
                    return;

                var row = e.getDocumentPosition().row;
                toggleBreakpoint(row, true);
                e.stop();
            });
        }
        var staticWordCompleter = {
            getCompletions: function(editor, session, pos, prefix, callback) {
                try{
                    var wordList;
                    if(language == 'java'){
                        bridge.initAutoComplete();
                        wordList = JSON.parse(autoCompleteList);
                    }else if(language == 'js' || language == 'ts' || language == 'jsx'){
                        var key = getKeyWord();
                        bridge.initAutoComplete(key);
                        wordList = JSON.parse(autoCompleteList);
                    }else if(language == 'sql'){
                        var key = getKeyWord();
                        prepareSqlAutocomplete(key);
                        wordList = autoCompleteListObj;
                    }else if(language == 'css'){
                        prepareCssAutocomplete();
                        wordList = autoCompleteListObj;
                    }else if(language == 'html'){
                        prepareHtmlAutocomplete();
                        wordList = autoCompleteListObj;
                    }
                    callback(null, wordList.map(function(word) {
                        return word;
                    }));
                }catch(e){
                    document.getElementById("editor").innerHTML = e.toString();
                }
            }
        };
        //langTools.setCompleters([staticWordCompleter])
        // or
        if(bridge || language == 'sql'){
            editor.completers = [staticWordCompleter];
        }
    }catch(e){
        document.getElementById("editor").innerHTML = e.toString();
    }
}
function clearMarkers(){
    for(var i in markerIds){
        editor.getSession().removeMarker(markerIds[i]);
    }
    markerIds = [];
}
function clearBreakPointMarkers(){
    for(var i in breakPointMarkerIds){
        editor.getSession().removeMarker(breakPointMarkerIds[i]);
    }
    breakPointMarkerIds = [];
}
function goToLine(lineNumber){
    editor.resize(true);
    editor.scrollToLine(lineNumber, true, true, function () {});
    editor.gotoLine(lineNumber, 1, true);
    editor.focus();
}
function toggleBreakpoint(row, update) {
    var breakpoints = editor.session.getBreakpoints();
    if (typeof breakpoints[row] === typeof undefined) {
        editor.session.setBreakpoint(row);
        update && bridge.addBreakpointPoint(row + 1);
    } else {
        editor.session.clearBreakpoint(row);
        update && bridge.removeBreakpointPoint(row + 1);
    }
}

function getCaretPosition(){
    var caretPosition = parseInt(editor.getCursorPosition().column);
    return caretPosition;
}
function getText(start, length){
    var row = parseInt(editor.getCursorPosition().row);
    var text = editor.session.doc.getTextRange({start:{column: start, row: row}, end: {column: (start + length), row: row}});
    return text;
}

function getKeyWord() {
    var chars = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789_$";
    var txt1="";
    var i=0;
    for(i=getCaretPosition()-1; i>=0; i--){
        var c = getText(i, 1);
        if(chars.indexOf(c) > -1){
            txt1+=c;
        }else{
            break;
        }
    }
    txt1 = txt1.split("").reverse().join("");
    return txt1;
}

function showReplaceBox(searchedText, replacementText){
    editor.execCommand('replace');
    setTimeout(function(){
        editor.searchBox.searchInput.value = searchedText;
        editor.searchBox.replaceInput.value = replacementText;
    }, 500);
}

function prepareSqlAutocomplete(input){
    autoCompleteListObj = [];
    if(sqlAutoJson){
        for(var i in sqlAutoJson){
            autoCompleteListObj.push({
                "caption": sqlAutoJson[i],
                "meta": 'keyword',
                "snippet": sqlAutoJson[i]
            });
        }
    }
}

function prepareCssAutocomplete(){
    autoCompleteListObj = [];
    if(css3AutoJson){
        var txt1="";
        var i=0;
        for(i=getCaretPosition()-1; i>=0; i--){
            var c=getText(i, 1);
            if(/[a-zA-Z0-9\s-:;\t]/.test(c)){
                txt1+=c;
            }else{
                break;
            }
        }
        txt1 = txt1.split("").reverse().join("").trim();
        if(txt1.indexOf(":") > -1){
            txt1 = txt1.split(":")[0].trim();
            for(var i in css3AutoJson[txt1]){
                autoCompleteListObj.push({
                    "caption": css3AutoJson[txt1][i],
                    "meta": 'style',
                    "snippet": css3AutoJson[txt1][i]
                });
            }
        }else{
            var keys = Object.keys(css3AutoJson);
            for(var i in keys){
                autoCompleteListObj.push({
                    "caption": keys[i],
                    "meta": 'value',
                    "snippet": keys[i]
                });
            }
        }
    }
}

function prepareHtmlAutocomplete(){
    autoCompleteListObj = [];
    var tag = "";
    var attr = false;
    var txt1 = "";
    var i=0;
    for(i = getCaretPosition() - 1; i >= 0; i--){
        var c = getText(i, 1);
        if(c != "<"){
            txt1+=c;
        }else{
            break;
        }
    }
    txt1 = txt1.split("").reverse().join("").trim();
    if(txt1.indexOf(" ") > -1 && /[a-zA-Z\s]+/.test(txt1.split(" ")[txt1.split(" ").length-1] || txt1.endsWith(" "))){
        tag=txt1.split(" ")[0];
        attr=true;
    }else if(txt1.indexOf(" ") == -1){
        attr=false;
    }
    console.log(tag, attr, txt1);
    if(!attr && txt1.indexOf(" ") == -1){
        var keys = Object.keys(htmlAutoJson);
        for(var i in keys){
            autoCompleteListObj.push({
                "caption": keys[i],
                "meta": 'tag',
                "snippet": keys[i]
            });
        }
    }else if(/[a-zA-Z]+/.test(tag) && attr){
        for(var i in htmlAutoJson[tag]){
            autoCompleteListObj.push({
                "caption": htmlAutoJson[tag][i],
                "meta": 'attribute',
                "snippet": htmlAutoJson[tag][i]
            });
        }
    }
}


